<?php

namespace App\Actions\Payment;

use Cashfree\Cashfree;
use Cashfree\Model\OrderMeta;

class Payment
{
    public $client_id;
    public $client_secret;

    protected $cashfree;
    protected $order;

    

    public function __construct($client_id, $client_secret)
    {
        $this->$client_id = $client_id;
        $this->$client_secret = $client_secret;
        
        $this->cashfree = new \Cashfree\Cashfree(0,$client_id,$client_secret,"","","","");
        $this->order = new \Cashfree\Model\CreateOrderRequest();

    }

    public function addClientInfo($client){

        $fullname = $client->first_name.' '.$client->last_name;

        $customer_details = new \Cashfree\Model\CustomerDetails();
        $customer_details->setCustomerId("CUST-".$client->id);
        $customer_details->setCustomerPhone(trim($client->mobile));
        //$customer_details->setCustomerEmail($client->email);
        $customer_details->setCustomerName($fullname);

        $this->order->setCustomerDetails($customer_details);

    }

    public function addReturnUrl($returnurl)
    {
        $order_meta = new OrderMeta();
        $order_meta->setReturnUrl($returnurl);
        $this->order->setOrderMeta($order_meta);
    }

    public function generateSession()
    {
        try {
            $result = $this->cashfree->PGCreateOrder($this->order);
            $order = $result[0];
            return [
                     "status" => true,
                     "cf_order_id" => $order->getCfOrderId(),
                     "payment_session_id" => $order->getPaymentSessionId(),
                   ];
                

        } catch (\Exception $e) {
            return [
                "status" => false,
                "cf_order_id" => null,
                "payment_session_id" => null,
                "error" => $e->getMessage(),
              ];
        }
    }

    public function getOrderInfo($order_id)
    {
        try {
            $result = $this->cashfree->PGFetchOrder($order_id);
            $order = $result[0];
            return [
                     "status" => true,
                     "cf_order_id" => $order->getCfOrderId(),
                     "order_status" => $order->getOrderStatus(),
                   ];
                

        } catch (\Exception $e) {
            
            return [
                "status" => false,
                "cf_order_id" => null,
                "order_status" => null,
                "error" => $e->getMessage(),
              ];
        }
    }


}