<?php

namespace App\Console\Commands;

use Carbon\Carbon;

use App\Models\BrikUnit;
use App\Models\BookingBooking;
use App\Models\BrikUnitRating;
use Illuminate\Console\Command;
use App\Models\BookingBookingDetail;
use App\Models\BookingBookingRequest;

class incompleteBookingRecordClear extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:incomplete-booking-record-clear';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'incomplete booking record clear.(Run Every day Once in cron)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $before_date_time = Carbon::now()->subMinutes(5);

       $bookingRequests = BookingBookingRequest::where('booking_status','Initiated')
                        ->where('created_at', '<=', $before_date_time)->get();

       foreach($bookingRequests as $bookingRequest)
       {
            $bookings = BookingBooking::where('booking_request_id', $bookingRequest->id)->get();
            foreach($bookings as $booking){
                BookingBookingDetail::where('booking_id', $booking->id)->delete();
            }
            $bookings = BookingBooking::where('booking_request_id', $bookingRequest->id)->delete();
       }

       BookingBookingRequest::where('booking_status','Initiated')->where('created_at', '<=', $before_date_time)->delete();

       $this->info('Code execution ended.');
    }




}
