<?php

namespace App\Console\Commands;

use App\Actions\RU\RU;
use App\Models\BrikUnit;
use App\Models\RuPropertyPrice;
use Illuminate\Console\Command;

class pullRuPropertyPrices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:pull-ru-property-prices';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $properties =  BrikUnit::whereNotNull('ru_property_id')->get();
       
       foreach($properties as $property)
       {
          $from = date("Y-m-d");
          $to = date("Y-m-t", strtotime("+12 month ". $from));
          $ru = new RU;
          $result = $ru->getPropertyPrices($property->ru_property_id, $from, $to);
          
            if($result["Status"]["ID"] == 0)
            {

                if(array_key_exists("Prices", $result))
                {
                    if(array_key_exists("Season", $result["Prices"]))
                    {

                        if(array_key_exists(0, $result["Prices"]["Season"]))
                        {
                            //Delete previous records
                            RuPropertyPrice::where('brik_unit_id', $property->id)->delete();
                            // Season is a array of records
                            foreach($result["Prices"]["Season"] as $season){

                                $this->createOrUpdate($property, $season);

                            }

                        }else{
                            
                            //Delete previous records
                            RuPropertyPrice::where('brik_unit_id', $property->id)->delete();
                            // Season is single record
                            $season = $result["Prices"]["Season"];
                            $this->createOrUpdate($property, $season);
                        }

                    }
                }
            }
       }
       $this->info('Code execution ended.');
    }

    public function createOrUpdate($property, $season)
    {

        $ins = new RuPropertyPrice;
        $ins->brik_unit_id = $property->id;
        $ins->ru_property_id = $property->ru_property_id;
        $ins->from_date = $season["DateFrom"];
        $ins->to_date = $season["DateTo"];
        $ins->price = $season["Price"];
        $ins->extra = $season["Extra"];
        $ins->save();
    }
}
