<?php

namespace App\Filament\Admin\Resources\BookingBookingResource\Pages;

use Filament\Actions;
use App\Actions\RU\RU;
use App\Models\Client;
use App\Models\BookingBooking;
use App\Models\BookingBookingDetail;
use Illuminate\Support\Facades\Auth;
use App\Models\BookingBookingRequest;
use App\Models\CoinWalletTransaction;
use Filament\Resources\Pages\CreateRecord;
use App\Actions\Utility\BookingDynamicPrice;
use Illuminate\Validation\ValidationException;
use App\Filament\Admin\Resources\BookingBookingResource;

class CreateBookingBooking extends CreateRecord
{
    protected static string $resource = BookingBookingResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {

        $newReq = new BookingBookingRequest();
        $newReq->brik_unit_id = $data["brik_unit_id"];
        $newReq->booking_from_date = $data["date_check_in"];
        $newReq->booking_to_date = $data["date_check_out"];
        $newReq->date_blocked_from = $data["date_check_in"];
        $newReq->date_blocked_to = date("Y-m-d", strtotime("-1 day ".$data["date_check_in"]));
        $newReq->is_complimentary = $data["is_complimentary"];
        $newReq->booking_status = 'Active';
        $newReq->save();

        $data["booking_request_id"] = $newReq->id;
        $data["booking_status"] = 'Active';
        $data["booking_from"] = 'Admin Panel';
        $data["user_id"] = Auth::user()->id;
        return $data;
    }

    public function afterCreate()
    {
        if($this->record->pay_by == 'Coin')
        {
            $cointxn = new CoinWalletTransaction;
            $cointxn->booking_id = $this->record->id;
            $cointxn->type = 'Debit';
            $cointxn->coin = $this->record->booking_cost_in_coin;
            $cointxn->save();

            $client = Client::find($this->record->client_id);
            $client->coins = ($client->coins - $this->record->booking_cost_in_coin);
            $client->save();
        }

        if($this->record->pay_by == 'Amount')
        {
            $price = new BookingDynamicPrice($this->record->brik_unit_id, $this->record->date_check_in, $this->record->date_check_out);
            $prices = $price->extractDates()->groupDatesWithPrice()->finalGrouping()->addDaysAndPrice()->get();

            foreach($prices as $price){
               $ins = new BookingBookingDetail;
               $ins->booking_id = $this->record->id;
               $ins->from_date = $price["from"];
               $ins->to_date = $price["to"];
               $ins->price = $price["price"];
               $ins->nights = $price["nights"];
               $ins->booking_price = $price["booking_price"];
               $ins->save();
            }

        }

        $this->RUApi();

    }

    public function RUApi()
    {
        $book = BookingBooking::find($this->record->id);
        $bookings = BookingBooking::with(['brik_unit', 'client'])->where('booking_request_id', $book->booking_request_id)->get();

                // Add RU Booking API Here

                foreach($bookings as $booking){

                    if($booking->brik_unit){

                        if($booking->brik_unit->ru_property_id){

                            if(is_null($booking->ru_reservation_id)){

                                if($booking->booking_status == 'Active')
                                {

                                    if($booking->pay_by == 'Amount'){
                                        // Booking By Amount

                                        $ru =  new RU;
                                        $ru->amountBooking($booking);

                                    }

                                    if($booking->pay_by == 'Coin'){
                                        // Booking By Coin
                                        // if booking has not entered in rentals united

                                        $ru =  new RU;
                                        $ru->coinBooking($booking);

                                    }
                                }
                            }
                        }

                    }
                }
    }


}
