<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Client;
use App\Models\BrikUnit;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DatePicker;
use Illuminate\Database\Eloquent\Builder;
use App\Models\BookingComplimentaryCoupon;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BookingComplimentaryCouponResource\Pages;
use App\Filament\Admin\Resources\BookingComplimentaryCouponResource\RelationManagers;

class BookingComplimentaryCouponResource extends Resource
{
    protected static ?string $model = BookingComplimentaryCoupon::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BOOKING';

    protected static ?string $modelLabel = 'Complimentary Coupon';

    protected static ?string $pluralModelLabel = 'Complimentary Coupons';

    protected static ?string $navigationLabel = 'Complimentary Coupon';

    protected static ?int $navigationSort = 59;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make()->schema([

                    Select::make('client_id')
                    ->label('Brik Owner')
                    ->options(Client::where('is_owner', 1)->pluck('full_name', 'id'))
                    ->required(),

                    Select::make('brik_unit_id')
                    ->label('Brik Unit')
                    ->options(BrikUnit::where('invest_active', 1)->where('rent_active', 1)->pluck('booking_portal_display_name', 'id'))
                    ->required(),

                    TextInput::make('no_of_nights')
                    ->required(),

                    DatePicker::make('valid_till')
                    ->required(),



                ])->columnSpan(2)->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                TextColumn::make('client.print_name')
                ->label('Brik Owner')
                ->sortable()
                ->searchable(),

                TextColumn::make('brik_unit.booking_portal_display_name')
                ->sortable()
                ->searchable(),

                TextColumn::make('no_of_nights'),

                TextColumn::make('valid_till')
            ])
            ->filters([
                //
            ])
            ->actions([
               Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBookingComplimentaryCoupons::route('/'),
            'create' => Pages\CreateBookingComplimentaryCoupon::route('/create'),
            'edit' => Pages\EditBookingComplimentaryCoupon::route('/{record}/edit'),
        ];
    }
}
