<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Client;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Forms\Form;
use App\Models\BrikOwner;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\BrikPaymentmyplan;
use App\Actions\Utility\SelectDymanicNames;
use App\Models\BrikAnnualMaintenance;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DatePicker;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikAnnualMaintenanceResource\Pages;
use App\Filament\Admin\Resources\BrikAnnualMaintenanceResource\RelationManagers;

class BrikAnnualMaintenanceResource extends Resource
{
    protected static ?string $model = BrikAnnualMaintenance::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BRIK OWNER';

    protected static ?string $modelLabel = 'Annual Maintenance';

    protected static ?string $pluralModelLabel = 'Annual Maintenances';

    protected static ?string $navigationLabel = 'Annual Maintenance';

    protected static ?int $navigationSort = 48;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([

               Select::make('brik_owner_id')
                ->live()
                ->label('Brik Owner')
                ->options(function(){
                   //$paymentplans = BrikPaymentmyplan::query()->pluck('name', 'id');
                   $owners = SelectDymanicNames::brikowner();
                   return $owners;
                })
                ->afterStateUpdated(function(Set $set, $state, Get $get){
                    self::fillWalletInfo($set, $state);
                })
                ->afterStateHydrated(function(Set $set, $state, Get $get){
                    self::fillWalletInfo($set, $state);
                })
                ->searchable()
                ->required()
                ->columnSpanFull(),

                Select::make('maintenance_year')
                ->options(function(){
                    return self::maintanceYearOptions();
                })
                ->default(function(Get $get){
                    if (is_null($get('id'))) {
                     return self::currentFinancialYear();
                    }
                }),


               TextInput::make('cost_per_year')
                ->label('Maintanance Cost (Yearly)')
                ->live(onBlur: true)
                ->afterStateUpdated(function (Get $get, Set $set){
                        self::calculatePayable($get, $set);
                })
                ->numeric(),

               DatePicker::make('due_date'),


               Section::make()->schema([

                TextInput::make('annual_maintenance_referal_discount')
                ->lte('wallet_current_balance')
                ->live(onBlur: true)
                ->afterStateUpdated(function (Get $get, Set $set){
                        self::calculatePayable($get, $set);
                })
                ->numeric()
                ->inputMode('decimal'),

                TextInput::make('wallet_current_balance')
                ->readonly()

              ])->columns(2),


              TextInput::make('payable_amount')
              ->numeric()
              ->readOnly()
              ->inputMode('decimal'),


            ])->columns(2),
            Section::make()->schema([
                Toggle::make('waived_off')
                ->columnSpanFull(),

               Toggle::make('maintenance_paid')
                ->columnSpanFull(),

               DatePicker::make('payment_date'),

            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('brikOwner.ownership_number')
				->label('Owner ID')
                ->sortable()
                ->searchable(),

				TextColumn::make('brikOwner.owner.print_name')
				->label('Owner Name')
                ->sortable()
                ->searchable(),

				TextColumn::make('brikOwner.owner.email')
				->label('Owner Email')
                ->sortable()
                ->searchable(),

				TextColumn::make('brikOwner.brik_unit.project.project_name')
				->label('Project')
                ->sortable()
                ->searchable(),

				TextColumn::make('brikOwner.brik_unit.unit_number')
				->label('Unit Number')
                ->sortable()
                ->searchable(),

                TextColumn::make('maintenance_year')
                ->searchable(),

                TextColumn::make('cost_per_year')
                ->label('Maintanance Cost (Yearly)')
                ->sortable()
                ->searchable(),

                TextColumn::make('due_date')
                ->date()
                ->searchable(),

                IconColumn::make('waived_off')->boolean(),

                IconColumn::make('maintenance_paid')->boolean(),

            ])
            ->filters([
                //
            ])
           ->actions([
                Tables\Actions\ActionGroup::make([
                Tables\Actions\EditAction::make(),
                Tables\Actions\Action::make('receipt')
                    ->label('Receipt')
                    ->icon('heroicon-o-link')
                    ->url(fn ($record) => route('amc.receipt', $record->id))
                    ->openUrlInNewTab()
                    ->visible(fn ($record) => $record->maintenance_paid),

                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikAnnualMaintenances::route('/'),
            'create' => Pages\CreateBrikAnnualMaintenance::route('/create'),
            'edit' => Pages\EditBrikAnnualMaintenance::route('/{record}/edit'),
        ];
    }

    public static function maintanceYearOptions()
    {

        $startyear = date('Y-m-d', strtotime('-4 year'));
        $years = [];
        $limit = 10;
        $i = 0;
        while($limit > $i){

            $value = date("Y", strtotime($startyear)).'-'.date('Y', strtotime("+1 year", strtotime($startyear)));
            $years[$value] = $value;
            $startyear = date('Y-m-d', strtotime("+1 year", strtotime($startyear)));

            $i++;
        }

        return $years;

    }

    public static function fillWalletInfo(&$set, &$state)
    {
        $cash_wallet = 0;

            $brik_owner = BrikOwner::find($state);

            if($brik_owner){

                $owner = Client::find($brik_owner->owner_id);

                if($owner){
                    $cash_wallet = $owner->wallet_amount;
                }
            }

        $set('wallet_current_balance', $cash_wallet);
    }

    public static function currentFinancialYear()
    {
            $date = date("Y-m-d");
            $month = date("m", strtotime(date("Y-m-d", strtotime($date))));
            $year = date("Y", strtotime(date("Y-m-d", strtotime($date))));
            if($month <= 3)
            {
                $financial_year = ($year - 1).'-'.$year;
            }
            elseif($month > 3)
            {
                $financial_year = $year.'-'.($year + 1);
            }
            return $financial_year;
    }

    public static function calculatePayable(&$get, &$set)
    {
        $cost_per_year = is_numeric($get('cost_per_year')) ? $get('cost_per_year') : 0;
        $annual_maintenance_referal_discount = is_numeric($get('annual_maintenance_referal_discount')) ? $get('annual_maintenance_referal_discount') : 0;
        $payable_amount = $cost_per_year - $annual_maintenance_referal_discount;
        $set('payable_amount', $payable_amount);
    }
}
