<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use App\Models\User;
use Filament\Tables;
use Filament\Forms\Get;
use Filament\Forms\Set;
use App\Models\BrikBrik;
use App\Models\BrikCity;
use App\Models\BrikType;
use Filament\Forms\Form;
use App\Models\BrikState;
use Filament\Tables\Table;
use App\Models\BrikProject;
use App\Models\BrikPropertyType;
use Filament\Resources\Resource;
use Illuminate\Support\Collection;
use Filament\Forms\Components\Tabs;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Tabs\Tab;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Forms\Components\FileUpload;
use Filament\Tables\Filters\SelectFilter;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\MarkdownEditor;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikBrikResource\Pages;
use App\Filament\Admin\Resources\BrikBrikResource\RelationManagers;

class BrikBrikResource extends Resource
{
    protected static ?string $model = BrikBrik::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $modelLabel = ' Unit Type';

    protected static ?string $pluralModelLabel = 'Unit Types';

    protected static ?string $navigationGroup = 'BRIK';

    protected static ?string $navigationLabel = 'Unit Type';

    protected static ?int $navigationSort = 22;


    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()
                ->schema([
                    Tabs::make('Project Details')
                        ->columnSpan(2) // Ensures full width
                        ->tabs([
                            Tab::make('Investment')
                                ->schema([

                                        Select::make('brik_project_id')
                                        ->label('Project')
                                        ->options(BrikProject::query()->pluck('project_name', 'id'))
                                        ->required(),

                                        Select::make('brik_type_id')->label('Category')->relationship('type', 'name')
                                        ->live()
                                        ->afterStateUpdated(function(Set $set, $state){
                                            self::updateDescription($set, $state);
                                        })->required(),

                                        // MarkdownEditor::make('description')->columnSpan(2),

                                        TextInput::make('property_area')->suffix('Sq ft'),

                                        //Select::make('brikManager')->relationship('brikManager', 'name'),

                                        TextInput::make('brik_value')->numeric()->inputMode('decimal')->required(),
                                        TextInput::make('capital_gain'),
                                        TextInput::make('irr')->label('IRR'),
                                        TextInput::make('pe_ratio')->label('PE Ratio')->numeric(),

                                        TextInput::make('per_night_coin')->label('Per night Coin')->numeric()->required(),
                                        TextInput::make('total_coins_per_brik')->label('Total coins per brik')->numeric(),

                                        Section::make()->schema([
                                            FileUpload::make('brik_invest_cover_image')
                                            ->label('Cover Image')
                                            ->image()
                                            ->directory('images/brik')
                                            ->imageEditor()
                                            ->columnSpan(1),

                                            FileUpload::make('brik_invest_gallery_images')
                                            ->label('Gallery Images')
                                            ->image()
                                            ->multiple()
                                            ->directory('images/brik')
                                            ->columnSpan(1),

                                        ])->columnSpan(2),


                                ])->columns(2),

                            Tab::make('Rental')
                                ->schema([

                                    Section::make()->schema([
                                        CheckboxList::make('addOnServices')
                                        ->relationship('addOnServices', 'feature')
                                        ->columns(3)
                                        ->columnSpan(2),
                                    ]),

                                    TextInput::make('per_night_inr')->label('Per night INR')->numeric()->inputMode('decimal')->required(),
                                    //MarkdownEditor::make('description')->columnSpan(2),
                                    FileUpload::make('brik_rent_cover_image')
                                    ->label('Cover Image')
                                    ->image()
                                    ->directory('images/brik')
                                    ->imageEditor(),

                                    FileUpload::make('brik_rent_gallery_images')
                                    ->label('Gallery Images')
                                    ->image()
                                    ->multiple()
                                    ->directory('images/brik'),

                                ])->columns(2),

                            Tab::make('Common')
                                ->schema([

                                    Section::make()->schema([
                                        CheckboxList::make('amenities')
                                        ->relationship('amenities', 'feature')
                                        ->columns(3)
                                        ->columnSpan(2),
                                    ]),

                                    Select::make('brik_property_type_id')
                                    ->label('Type')
                                    ->options(BrikPropertyType::query()->pluck('name', 'id'))
                                    ->required(),



                                    TextInput::make('bedroom'),
                                    TextInput::make('bathroom'),
                                    TextInput::make('accomadation')->label('Accomodation'),
                                    TextInput::make('adults_capacity')->numeric()->required(),
                                    TextInput::make('children_capacity')->numeric()->default(0)->required(),
                                    TextInput::make('infent_capacity')->label('Infant Capacity')->numeric()->default(0)->required(),
                                    TextInput::make('pet_capacity')->numeric()->default(0)->required(),





                                ])->columns(2),
                        ]),
                ])
                ->columnSpanFull(), // Makes the whole section full width
        ])
        ->columns(1);

        // ->schema([
        //     Section::make()->schema([

        //         Select::make('brik_project_id')
        //             ->label('Project')
        //             ->options(BrikProject::query()->pluck('project_name', 'id'))
        //             ->required(),

        //         Select::make('brik_property_type_id')
        //         ->label('Type')
        //         ->options(BrikPropertyType::query()->pluck('name', 'id'))
        //         ->required(),

        //         Select::make('brik_type_id')->label('Category')->relationship('type', 'name')
        //         ->live()
        //         ->afterStateUpdated(function(Set $set, $state){
        //             self::updateDescription($set, $state);
        //         })->required(),

        //         MarkdownEditor::make('description')->columnSpan(3),


        //     ])->columns(3),

        //     Section::make()->schema([

        //         Select::make('amenities')->multiple()->relationship('amenities', 'feature'),
        //         Select::make('addOnServices')->multiple()->relationship('addOnServices', 'feature'),
        //         TextInput::make('property_area')->suffix('Sq ft'),
        //         TextInput::make('bedroom'),
        //         TextInput::make('bathroom'),
        //         TextInput::make('accomadation'),
        //         TextInput::make('adults_capacity')->numeric(),
        //         TextInput::make('children_capacity')->numeric(),

        //     ])->columns(3),

        //     Section::make()->schema([


        //         Select::make('brikManager')->relationship('brikManager', 'name'),
        //         TextInput::make('brik_value')->numeric()->inputMode('decimal'),
        //         TextInput::make('capital_gain')->numeric()->suffix('%'),
        //         TextInput::make('irr')->label('IRR')->numeric()->suffix('%'),
        //         TextInput::make('pe_ratio')->label('PE Ratio')->numeric(),

        //     ])->columns(3),

        //     Section::make()->schema([

        //         FileUpload::make('brik_cover_image')
        //         ->image()
        //         ->directory('images/brik')
        //         ->imageEditor(),

        //         FileUpload::make('brik_gallery_images')
        //         ->image()
        //         ->multiple()
        //         ->directory('images/brik')

        //     ])->columns(2),

        //     Section::make()->schema([

        //         TextInput::make('per_night_inr')->label('Per night INR')->numeric()->inputMode('decimal'),
        //         TextInput::make('per_night_coin')->label('Per night Coin')->numeric()->suffix('%'),
        //         TextInput::make('total_coins_per_brik')->label('Total coins per brik')->numeric(),

        //     ])->columns(3),

        //     Section::make()->schema([

        //         Toggle::make('active')

        //     ])->columns(3)


        // ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('project.project_name')
                ->sortable()
                ->searchable(),

                TextColumn::make('propertyType.name')
				->label('Type')
                ->sortable()
                ->searchable(),

                TextColumn::make('type.name')
				->label('Category')
                ->sortable()
                ->searchable(),

                TextColumn::make('brik_value')
                ->sortable()
                ->searchable(),

                TextColumn::make('project.projectManager.name')
				->label('Project Manager')
                ->sortable()
                ->searchable(),


            ])
            ->filters([
                SelectFilter::make('propertyType')
                ->label('Type')
                ->relationship('propertyType', 'name'),

                SelectFilter::make('type')
                ->label('Category')
                ->relationship('type', 'name'),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {

                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('Brik is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted Brik record.')
                                ->send();

                        $record->delete();
                    }),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()->action(function ($records) {
                        return self::bulkdelete($records);
                    }),
                ]),
            ])
            ->paginated([10, 25, 50, 100]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikBriks::route('/'),
            'create' => Pages\CreateBrikBrik::route('/create'),
            'edit' => Pages\EditBrikBrik::route('/{record}/edit'),
        ];
    }

    public static function updateDescription(&$set, &$state){
        $type = BrikType::find($state);
        $description = $type ? $type->description : '';
        $set('description', $description);
        $set('address', $description);
    }

    public static function bulkdelete($records){
        $success = 0;
        $failed = 0;
        foreach($records as $record){
            if ($record->childRecordCounts() > 0 ) {
                $failed ++;
            }else{
                $success ++;
                $record->delete();
            }
        }


            Notification::make()
                ->danger()
                ->title("{$success} records deleted, {$failed} records not deleted.")
                ->body("{$success} records deleted, {$failed} records not deleted.")
                ->send();

    }
}
