<?php

namespace App\Filament\Admin\Resources\BrikBrikResource\Pages;

use Filament\Actions;
use App\Models\BrikType;
use App\Models\BrikUnit;
use App\Models\BrikProject;
use App\Models\BrikPropertyType;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Admin\Resources\BrikBrikResource;

class CreateBrikBrik extends CreateRecord
{
    protected static string $resource = BrikBrikResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }
    
    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $project = BrikProject::find($data['brik_project_id']);
        $propertytype = BrikPropertyType::find($data['brik_property_type_id']);
        $type = BrikType::find($data['brik_type_id']);
        
        if($project && $propertytype){
            $data['brik_name'] = $project->project_name.' - '.$propertytype->name.' - '.$type->name;
        }
        
        return $data;
    }

    protected function afterCreate()
    {
        BrikUnit::where('brik_id', $this->record->id)->update([
            "adults_capacity" => $this->record->adults_capacity,
            "children_capacity" => $this->record->children_capacity,
            "infent_capacity" => $this->record->infent_capacity,
            "pet_capacity" => $this->record->pet_capacity,
        ]);
    }

}
