<?php

namespace App\Filament\Admin\Resources\BrikBrikResource\Pages;

use App\Actions\Utility\EditPageHeaderNames;
use Filament\Actions;
use App\Models\BrikType;
use App\Models\BrikProject;
use App\Models\BrikPropertyType;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Contracts\Support\Htmlable;
use App\Filament\Admin\Resources\BrikBrikResource;
use App\Models\BrikUnit;

class EditBrikBrik extends EditRecord
{
    protected static string $resource = BrikBrikResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    public function getTitle(): string | Htmlable
    {
        return EditPageHeaderNames::brikBrik($this->record->id);
        // return $this->record->brik_name;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
         $project = BrikProject::find($data['brik_project_id']);
         $propertytype = BrikPropertyType::find($data['brik_property_type_id']);
         $type = BrikType::find($data['brik_type_id']);
         
         if($project || $propertytype || $type){
            $data['brik_name'] = $project->project_name.' - '.$propertytype->name.' - '.$type->name;
         }
         
         return $data;
    }

    protected function afterSave()
    {
        BrikUnit::where('brik_id', $this->record->id)->update([
                "adults_capacity" => $this->record->adults_capacity,
                "children_capacity" => $this->record->children_capacity,
                "infent_capacity" => $this->record->infent_capacity,
                "pet_capacity" => $this->record->pet_capacity,
        ]);
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->action(function ($record) {
                        
                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('Brik is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted Brik record.')
                        ->send();

                $record->delete();

                return redirect(BrikBrikResource::getUrl('index'));
            }),
        ];
    }
}
