<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;

use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\BrikCancellationPolicy;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Forms\Components\RichEditor;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\MarkdownEditor;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikCancellationPolicyResource\Pages;
use App\Filament\Admin\Resources\BrikCancellationPolicyResource\RelationManagers;

class BrikCancellationPolicyResource extends Resource
{
    protected static ?string $model = BrikCancellationPolicy::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'MASTER';

    protected static ?string $modelLabel = 'Cancellation Policy';

    protected static ?string $pluralModelLabel = 'Cancellation Policies';

    protected static ?string $navigationLabel = 'Cancellation Policy';

    protected static ?int $navigationSort = 10;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([
                TextInput::make('title')->required()->live(onBlur: true)->unique(ignoreRecord: true),
                RichEditor::make('cancellation_policy')->required(),
            ])
        ])
        ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('title')
                 ->sortable()
                 ->searchable(),

                // TextColumn::make('cancellation_policy')
                // ->sortable()
                // ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {

                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('Cancellation policy is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted Cancellation policy record.')
                                ->send();

                        $record->delete();
                    }),
                ])

            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()->action(function ($records) {
                        return self::bulkdelete($records);
                    }),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikCancellationPolicies::route('/'),
            'create' => Pages\CreateBrikCancellationPolicy::route('/create'),
            'edit' => Pages\EditBrikCancellationPolicy::route('/{record}/edit'),
        ];
    }

    public static function bulkdelete($records){
        $success = 0;
        $failed = 0;
        foreach($records as $record){
            if ($record->childRecordCounts() > 0 ) {
                $failed ++;
            }else{
                $success ++;
                $record->delete();
            }
        }


            Notification::make()
                ->danger()
                ->title("{$success} records deleted, {$failed} records not deleted.")
                ->body("{$success} records deleted, {$failed} records not deleted.")
                ->send();

    }
}
