<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\BrikCity;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Tables\Columns\ImageColumn;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikCityResource\Pages;
use App\Filament\Admin\Resources\BrikCityResource\RelationManagers;

class BrikCityResource extends Resource
{
    protected static ?string $model = BrikCity::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'MASTER';

    protected static ?string $modelLabel = 'City';
    
    protected static ?string $pluralModelLabel = 'Cities';

    protected static ?string $navigationLabel = 'City';

    protected static ?int $navigationSort = 5;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([

            Section::make()->schema([

                TextInput::make('name')->required()->live(onBlur: true)->unique(ignoreRecord: true),

                Select::make('brik_state_id')
                ->relationship('state', 'name')
                ->required(),

                FileUpload::make('icon')
                    ->image()
                    ->required()
                    ->directory('images/city')
                    ->imageEditor(),
            ])
            
        ])
        ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('name')
                ->sortable()
                ->searchable(),

                TextColumn::make('state.name')
                ->sortable()
                ->searchable(),

                ImageColumn::make('icon'),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {
                        
                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('City is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted City record.')
                                ->send();

                        $record->delete();
                    }),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()->action(function ($records) {
                        return self::bulkdelete($records);
                    }),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikCities::route('/'),
            'create' => Pages\CreateBrikCity::route('/create'),
            'edit' => Pages\EditBrikCity::route('/{record}/edit'),
        ];
    }

    public static function bulkdelete($records){
        $success = 0;
        $failed = 0;
        foreach($records as $record){
            if ($record->childRecordCounts() > 0 ) {
                $failed ++;
            }else{
                $success ++;
                $record->delete();
            }
        }

        
            Notification::make()
                ->danger()
                ->title("{$success} records deleted, {$failed} records not deleted.")
                ->body("{$success} records deleted, {$failed} records not deleted.")
                ->send();
        
    }
}
