<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BrikHouserule;
use Filament\Resources\Resource;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\RichEditor;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikHouseruleResource\Pages;
use App\Filament\Admin\Resources\BrikHouseruleResource\RelationManagers;

class BrikHouseruleResource extends Resource
{
    protected static ?string $model = BrikHouserule::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'MASTER';

    protected static ?string $modelLabel = 'House Rule';

    protected static ?string $pluralModelLabel = 'House Rules';

    protected static ?string $navigationLabel = 'House Rule';

    protected static ?int $navigationSort = 7;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([
                TextInput::make('title')->required()->live(onBlur: true)->unique(ignoreRecord: true),
                RichEditor::make('rule')->required(),
            ])
        ])
        ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([
                TextColumn::make('title')
                ->sortable()
                ->searchable(),

                // TextColumn::make('rule')
                // ->sortable()
                // ->searchable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {

                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('House rule is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted House rule record.')
                                ->send();

                        $record->delete();
                    }),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()->action(function ($records) {
                        return self::bulkdelete($records);
                    }),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikHouserules::route('/'),
            'create' => Pages\CreateBrikHouserule::route('/create'),
            'edit' => Pages\EditBrikHouserule::route('/{record}/edit'),
        ];
    }

    public static function bulkdelete($records){
        $success = 0;
        $failed = 0;
        foreach($records as $record){
            if ($record->childRecordCounts() > 0 ) {
                $failed ++;
            }else{
                $success ++;
                $record->delete();
            }
        }


            Notification::make()
                ->danger()
                ->title("{$success} records deleted, {$failed} records not deleted.")
                ->body("{$success} records deleted, {$failed} records not deleted.")
                ->send();

    }
}
