<?php

namespace App\Filament\Admin\Resources\BrikInstallmentResource\Pages;

use Filament\Actions;
use App\Models\Client;
use App\Models\BrikOwner;
use App\Models\BrikPaymentmyplan;
use App\Models\CashWalletTransaction;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Admin\Resources\BrikInstallmentResource;
use App\Models\BrikInstallment;
use App\Models\BrikInstallmentPayment;

class CreateBrikInstallment extends CreateRecord
{
    protected static string $resource = BrikInstallmentResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function afterCreate()
    {
        $this->updatePaymentCollection($this->record);

        if($this->record->installment_amount > 0){
           $upd = BrikInstallment::find($this->record->id);
           $upd->active = 1;
           $upd->save();
        }

        if($this->record->installment_referal_discount){

            $paymentplan = BrikPaymentmyplan::find($this->record->payment_plan_id);

            if($paymentplan){

                $brik_owner = BrikOwner::find($paymentplan->brik_owner_id);

                if($brik_owner){

                    $owner = Client::find($brik_owner->owner_id);

                    if($owner){

                        $this->cashWalletTransactionINSTALL($owner->id, $this->record->id, $this->record->installment_referal_discount);
                    }
                }
            }
        }
    }

    protected function cashWalletTransactionINSTALL($client_id, $installment_id, $amount)
    {
        $qry = CashWalletTransaction::where('category', 'Installment Referral Discount')
        ->where('client_id', $client_id)
        ->where('brik_installment_id', $installment_id);

        if($qry->count() > 0){

            $upd = CashWalletTransaction::find($qry->first()->id);
            $upd->amount = $amount;
            $upd->signed_amount = (-1) * $amount;
            $upd->save();

        }else{

            $ins = new CashWalletTransaction;
            $ins->brik_installment_id = $installment_id;
            $ins->category = 'Installment Referral Discount';
            $ins->client_id = $client_id;
            $ins->amount = $amount;
            $ins->type = 'Debit';
            $ins->date = date("Y-m-d");
            $ins->signed_amount = (-1) * $amount;
            $ins->save();

        }

        return;
    }

    protected function updatePaymentCollection($installment){

        $payment_sum = BrikInstallmentPayment::where('brik_installment_id', $installment->id)->sum('paid_amount');

        $installment_paid = 0;
        if((float)$payment_sum == (float)$installment->payable_amount){
            $installment_paid = 1;
        }
        $ins = BrikInstallment::find($installment->id);
        $ins->amount_paid = $payment_sum;
        $ins->paid_date = date("Y-m-d");
        $ins->balance_amount = ($ins->payable_amount - $payment_sum);
        $ins->installment_paid = $installment_paid;
        $ins->save();
    }
}
