<?php

namespace App\Filament\Admin\Resources\BrikProjectResource\Pages;

use Filament\Actions;
use App\Models\BrikUnit;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Admin\Resources\BrikProjectResource;

class CreateBrikProject extends CreateRecord
{
    protected static string $resource = BrikProjectResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function afterCreate()
    {
        BrikUnit::where('project_id', $this->record->id)->update([
            "city_id" => $this->record->city_id,
        ]);
    }
}
