<?php

namespace App\Filament\Admin\Resources\BrikProjectResource\Pages;

use Filament\Actions;
use App\Models\BrikUnit;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Contracts\Support\Htmlable;
use App\Filament\Admin\Resources\BrikProjectResource;

class EditBrikProject extends EditRecord
{
    protected static string $resource = BrikProjectResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    public function getTitle(): string | Htmlable
    {
        return $this->record->project_name;
    }

    protected function afterSave()
    {
        BrikUnit::where('project_id', $this->record->id)->update([
            "city_id" => $this->record->city_id,
        ]);
    }
    
    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->action(function ($record) {
                        
                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('Project is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted Project record.')
                        ->send();

                $record->delete();
            }),
        ];
    }
}
