<?php

namespace App\Filament\Admin\Resources\BrikTypeResource\Pages;

use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Admin\Resources\BrikTypeResource;

class EditBrikType extends EditRecord
{
    protected static string $resource = BrikTypeResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->action(function ($record) {
                        
                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('Category is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted Category record.')
                        ->send();

                $record->delete();

                return redirect(BrikTypeResource::getUrl('index'));

            }),
        ];
    }
}
