<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BrikUnitRating;
use Filament\Resources\Resource;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikUnitRatingResource\Pages;
use App\Filament\Admin\Resources\BrikUnitRatingResource\RelationManagers;
use App\Models\BrikUnit;

class BrikUnitRatingResource extends Resource
{
    protected static ?string $model = BrikUnitRating::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BRIK';

    protected static ?string $modelLabel = 'Brik Unit Rating';
    
    protected static ?string $pluralModelLabel = 'Brik Unit Ratings';

    protected static ?string $navigationLabel = 'Brik Unit Rating';

    protected static ?int $navigationSort = 27;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make()->schema([

                    Select::make('brik_unit_id')
                    ->label('Brik Unit')
                    ->options(BrikUnit::pluck('unit_name', 'id'))
                    ->required(),

                    Select::make('rating')->options([
                        "5" => 5,
                        "4.5" => 4.5,
                        "4" => 4,
                        "3.5" => 3.5,
                        "3" => 3,
                        "2.5" => 2.5,
                        "2" => 2,
                        "1.5" => 1.5,
                        "1" => 1
                    ])->required(),
                    Textarea::make('comment')->columnSpan(2),

                ])->columns(2)
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('unit.unit_name')
                ->default('Anonymous')
                ->sortable()
                ->searchable(),

                TextColumn::make('client.full_name')
                ->label('User')
                ->default('Anonymous')
                ->sortable()
                ->searchable(),

                TextColumn::make('rating')
                ->sortable()
                ->searchable(),

                TextColumn::make('comment')
                ->sortable()
                ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikUnitRatings::route('/'),
            'create' => Pages\CreateBrikUnitRating::route('/create'),
            'edit' => Pages\EditBrikUnitRating::route('/{record}/edit'),
        ];
    }
}
