<?php

namespace App\Filament\Admin\Resources\BrikUnitResource\Pages;

use Filament\Actions;
use App\Models\BrikBrik;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Admin\Resources\BrikUnitResource;
use App\Models\BrikProject;

class CreateBrikUnit extends CreateRecord
{
    protected static string $resource = BrikUnitResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $brik = BrikBrik::find($data['brik_id']);
        if($brik){

            $project = BrikProject::find($data['project_id']);

            if($project){
                $data['city_id'] = $project->city_id;
            }

            $data['unit_name'] = $brik->brik_name.' - '.$data['unit_number'];
            $data['adults_capacity'] = $brik->adults_capacity;
            $data['children_capacity'] = $brik->children_capacity;
            $data['infent_capacity'] = $brik->infent_capacity;
            $data['pet_capacity'] = $brik->pet_capacity;
        }else{ 
            $data['unit_name'] = $data['unit_number'];
        }
        
        return $data;
    }
}
