<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Client;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\CashWalletTransaction;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DatePicker;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\CashWalletTransactionResource\Pages;
use App\Filament\Admin\Resources\CashWalletTransactionResource\RelationManagers;

class CashWalletTransactionResource extends Resource
{
    protected static ?string $model = CashWalletTransaction::class;

    protected static bool $shouldRegisterNavigation = false;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'USER';

    protected static ?string $modelLabel = 'Cash Wallet Transaction';
    
    protected static ?string $pluralModelLabel = 'Cash Wallet Transactions';

    protected static ?string $navigationLabel = 'Cash Wallet Transaction';

    protected static ?int $navigationSort = 76;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([

               Select::make('client_id')
                ->live()
                ->label('User')
                ->options(Client::query()->where('is_owner', 1)->pluck('full_name', 'id'))
                ->afterStateUpdated(function(Set $set, $state, Get $get){
                     self::fillUserCurrentWalletBalance($set, $state);
                })
                ->required(),

              TextInput::make('current_balance')
                ->readOnly(),
                

              Select::make('type')
                ->label('Transaction Type')
                ->options([
                    "Credit" => "Credit",
                    "Debit" => "Debit",
                ])
                ->required(),

              Select::make('category')
                ->label('Transaction Category')
                ->options([
                    "Recharge" => "Recharge",
                    "Refund" => "Refund",
                    "Brik Sale" => "Brik Sale",
                    "Penalty" => "Penalty",
                    "Annual Credit" => "Annual Credit"
                ])
                ->required(),

               TextInput::make('amount')
                ->label('Amount')
                ->numeric()
                ->required(),

              
               DatePicker::make('date')
               ->required(),

               Textarea::make('remark')
               ->columnSpanFull()

              
            ])->columns(2),
           
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('client.full_name')
                ->label('User Wallet')
                ->sortable()
                ->searchable(),

                TextColumn::make('category')
                ->sortable()
                ->searchable(),

                TextColumn::make('type')
                ->sortable()
                ->searchable(),

                TextColumn::make('amount')
                ->sortable()
                ->searchable(),

                TextColumn::make('date')
                ->sortable()
                ->searchable(),

                TextColumn::make('remark')
                ->sortable()
                ->searchable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCashWalletTransactions::route('/'),
            'create' => Pages\CreateCashWalletTransaction::route('/create'),
            'edit' => Pages\EditCashWalletTransaction::route('/{record}/edit'),
        ];
    }

    public static function fillUserCurrentWalletBalance(&$set, &$state)
    {
        $client = Client::find($state);
        $set('current_balance', $client->wallet_amount);
    }
}
