<?php

namespace App\Filament\Admin\Resources\CashWalletTransactionResource\Pages;

use App\Filament\Admin\Resources\CashWalletTransactionResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateCashWalletTransaction extends CreateRecord
{
    protected static string $resource = CashWalletTransactionResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if($data['type'] == 'Debit'){
            $data['signed_amount'] = $data['amount'] * -1;
        }else{
            $data['signed_amount'] = $data['amount'];
        }
        
        return $data;
    }
}
