<?php

namespace App\Filament\Admin\Resources\ClientResource\Pages;

use App\Filament\Admin\Resources\ClientResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Resources\Components\Tab;
use Illuminate\Database\Eloquent\Builder;

class ListClients extends ListRecords
{
    protected static string $resource = ClientResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            // 'all' => Tab::make(),
            'owner' => Tab::make()
                ->modifyQueryUsing(fn (Builder $query) => $query->where('is_owner', 1)),
            'visitor' => Tab::make()
                ->modifyQueryUsing(fn (Builder $query) => $query->where('is_owner', 0)),
        ];
    }
}
