<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Set;
use Filament\Forms\Form;
use App\Models\InvestBlog;
use Filament\Tables\Table;
use Illuminate\Support\Str;
use Filament\Tables\Actions\Action;
use Filament\Resources\Resource;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\RichEditor;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\InvestBlogResource\Pages;
use App\Filament\Admin\Resources\InvestBlogResource\RelationManagers;

class InvestBlogResource extends Resource
{
    protected static ?string $model = InvestBlog::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'INVESTMENT PORTAL CMS';

    protected static ?string $modelLabel = 'Blog';

    protected static ?string $pluralModelLabel = 'Blogs';

    protected static ?string $navigationLabel = 'Blog';

    protected static ?int $navigationSort = 50;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([

	            Section::make()->schema([

                    TextInput::make('title')
                    ->live(onBlur: true)
                    ->required()
                    ->afterStateUpdated(fn (Set $set, ?string $state) => $set('slug', Str::slug($state))),

                    TextInput::make('slug')
                    ->required(),

                    FileUpload::make('image')
                        ->image()
                        ->required()
                        ->directory('images/invest/blog')
                        ->imageEditor(),

                    RichEditor::make('body')
                    ->required(),

                ])

            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                 TextColumn::make('title')
                ->sortable()
                ->searchable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Action::make('edit_metadata')
                    ->label('Metadata')
                    ->icon('heroicon-c-pencil-square')
                    ->color('primary')
                    ->url(fn (InvestBlog $record): string => InvestBlogResource::getUrl('metadata', ['record' => $record->id])), // Use record ID for context
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListInvestBlogs::route('/'),
            'create' => Pages\CreateInvestBlog::route('/create'),
            'edit' => Pages\EditInvestBlog::route('/{record}/edit'),
            'metadata' => Pages\EditInvestBlogMetadata::route('/{record}/meta-edit'),
        ];
    }
}
