<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Get;
use Filament\Forms\Set;
use App\Models\BrikBrik;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BrikProject;
use Illuminate\Support\Str;
use Filament\Resources\Resource;
use Filament\Tables\Actions\Action;
use App\Models\InvestPropertyDetail;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\RichEditor;
use Illuminate\Database\Eloquent\Builder;
use App\Actions\Utility\SelectDymanicNames;
use Filament\Forms\Components\CheckboxList;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\InvestPropertyDetailResource\Pages;
use App\Filament\Admin\Resources\InvestPropertyDetailResource\RelationManagers;

class InvestPropertyDetailResource extends Resource
{
    protected static ?string $model = InvestPropertyDetail::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'INVESTMENT PORTAL CMS';

    protected static ?string $modelLabel = 'Property';

    protected static ?string $pluralModelLabel = 'Property';

    protected static ?string $navigationLabel = 'Property';

    protected static ?int $navigationSort = 49;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
	            Section::make()->schema([

                        Select::make('brik_project_id')
                        ->label('Project')
                        ->live()
                        ->disabledOn('edit')
                        ->options(function(Get $get){

                            if(is_null($get('id'))){

                            //    $exist_project_ids = InvestPropertyDetail::query()->pluck('brik_project_id')->toArray();
                            //    return BrikProject::query()->whereNotIn('id', $exist_project_ids)->pluck('project_name', 'id');

                            return BrikProject::query()->pluck('project_name', 'id');

                            }else{

                                return BrikProject::query()->where('id', $get('brik_project_id'))->pluck('project_name', 'id');

                            }

                        })->required(),

                        Select::make('brik_id')
                            ->label('Unit Type')
                            ->required()
                            ->live()
                            ->disabledOn('edit')
                            ->afterStateUpdated(function(Set $set, $state, Get $get){
                                //if (is_null($get('id'))) {
                                    self::fillFromUnitType($set, $state);
                                //}
                            })
                            ->options(
                                function (Get $get){
                                //   return  BrikBrik::query()->where('brik_project_id', $get('project_id'))
                                //   ->pluck('brik_name', 'id');
                                $briks = SelectDymanicNames::brik_project($get('brik_project_id'));
                                return $briks;

                            }),

                        Textarea::make('description')
						->columnSpan(2),

                        TextInput::make('invest_portal_display_name')
                        ->live(onBlur: true)
                        ->afterStateUpdated(fn (Set $set, ?string $state) => $set('slug', Str::slug($state)))
                        ->required(),

                        TextInput::make('slug')
                        ->required(),

                        TextInput::make('property_area'),
                        TextInput::make('target_rental_yield'),
                        TextInput::make('possession_status'),

                        TextInput::make('brik_value'),
                        TextInput::make('booking_amount'),
                        TextInput::make('capital_gain'),
                        TextInput::make('irr')->label('IRR'),
                        TextInput::make('pe_ratio')->label('PE Ratio'),

                        TextInput::make('bedroom'),
                        TextInput::make('bathroom'),
                        TextInput::make('adults_capacity'),
                        TextInput::make('children_capacity'),
                        Select::make('status')
                        ->options(
                                [
                                    "Newly Launched" => "Newly Launched",
                                    "Limited Inventory" => "Limited Inventory",
                                    "Sold Out" => "Sold Out"
                                ]
                            ),

                        Section::make()->schema([
                            CheckboxList::make('amenities')
                            ->relationship('amenities', 'feature')
                            ->columns(3)
                            ->columnSpan(2),
                        ]),

                        Section::make()->schema([
                            RichEditor::make('about_property')
                        ])->columnSpan(2),

                        Section::make()->schema([
                            Repeater::make('payment_plan')
                            ->schema([
                                TextInput::make('name'),
                                TextInput::make('validity'),
                                TextInput::make('inr'),
                            ])->columns(3),
                        ])->columnSpan(2),

                        Section::make()->schema([
                            Repeater::make('bifurcation_of_unit_cost')
                            ->schema([
                                TextInput::make('head'),
                                TextInput::make('whole_unit_cost'),
                                TextInput::make('brik_fraction_cost'),
                            ])->columns(3),
                        ])->columnSpan(2),



                        Section::make()->schema([

                            FileUpload::make('cover_image')
                            ->label('Cover Image')
                            ->image()
                            ->directory('images/invest/cover')
                            ->imageEditor()
                            ->columnSpan(1),

                            FileUpload::make('gallery_images')
                            ->label('Gallery Images')
                            ->image()
                            ->multiple()
                            ->directory('images/invest/gallery')
                            ->columnSpan(1),

                        ])->columnSpan(2),



                ])->columns(2)
                        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('invest_portal_display_name')
                ->label('Display name')
                ->sortable()
                ->searchable(),

                TextColumn::make('project.project_name')
                ->sortable()
                ->searchable(),

                TextColumn::make('brik.propertyType.name')
                ->sortable()
                ->searchable(),

                TextColumn::make('brik.type.name')
                ->sortable()
                ->searchable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Action::make('edit_metadata')
                    ->label('Metadata')
                    ->icon('heroicon-c-pencil-square')
                    ->color('primary')
                    ->url(fn (InvestPropertyDetail $record): string => InvestPropertyDetailResource::getUrl('metadata', ['record' => $record->id])), // Use record ID for context
                Tables\Actions\DeleteAction::make(),

            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }



    public static function getPages(): array
    {
        return [
            'index' => Pages\ListInvestPropertyDetails::route('/'),
            'create' => Pages\CreateInvestPropertyDetail::route('/create'),
            'edit' => Pages\EditInvestPropertyDetail::route('/{record}/edit'),
            'metadata' => Pages\EditInvestPropertyMetadata::route('/{record}/meta-edit'),
        ];
    }

    public static function fillFromUnitType(&$set, &$state)
    {
        $brik = BrikBrik::find($state);
        $property_area = $brik ? $brik->property_area : '';
        $brik_value = $brik ? $brik->brik_value : '';
        $capital_gain = $brik ? $brik->capital_gain : '';
        $irr = $brik ? $brik->irr : '';
        $pe_ratio = $brik ? $brik->pe_ratio : '';
        $per_night_coin = $brik ? $brik->per_night_coin : '';
        $total_coins_per_brik = $brik ? $brik->total_coins_per_brik : '';
        $per_night_inr = $brik ? $brik->per_night_inr : '';
        $bedroom = $brik ? $brik->bedroom : '';
        $bathroom = $brik ? $brik->bathroom : '';
        $adults_capacity = $brik ? $brik->adults_capacity : '';
        $children_capacity = $brik ? $brik->children_capacity : '';
        $set('property_area', $property_area);
        $set('brik_value', $brik_value);
        $set('capital_gain', $capital_gain);
        $set('irr', $irr);
        $set('pe_ratio', $pe_ratio);
        $set('per_night_coin', $per_night_coin);
        $set('total_coins_per_brik', $total_coins_per_brik);
        $set('per_night_inr', $per_night_inr);
        $set('bedroom', $bedroom);
        $set('bathroom', $bathroom);
        $set('adults_capacity', $adults_capacity);
        $set('children_capacity', $children_capacity);

    }
}
