<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Client;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Forms\Form;
use App\Models\BrikOwner;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\ReferralInsentive;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DatePicker;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\ReferralInsentiveResource\Pages;
use App\Filament\Admin\Resources\ReferralInsentiveResource\RelationManagers;

class ReferralInsentiveResource extends Resource
{
    protected static ?string $model = ReferralInsentive::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'USER';

    protected static ?string $modelLabel = 'Referral Incentive';

    protected static ?string $pluralModelLabel = 'Referral Incentives';

    protected static ?string $navigationLabel = 'Referral Incentive';

    protected static ?int $navigationSort = 76;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([

               Select::make('brik_owner_id')
                ->live()
                ->label('Brik Owner')
                ->options(function(Get $get){
                    if (is_null($get('id'))) {
                        return BrikOwner::whereNotNull('referrer_id')->whereNull('referrer_incentive_id')
                        ->pluck('select_name', 'id');
                    }else{
                        return BrikOwner::where('id', $get('brik_owner_id'))->pluck('select_name', 'id');
                    }
                })
                ->afterStateUpdated(function(Set $set, $state, Get $get){
                     self::fillReferrer($set, $state);
                })
                ->afterStateHydrated(function(Set $set, $state, Get $get){
                    self::fillReferrer($set, $state);
               })
                ->required()
                ->columnSpanFull(),

              Hidden::make('referrer_id'),

              TextInput::make('referrer_name')
                ->readOnly(),

              TextInput::make('amount')
                ->label('Amount')
                ->numeric()
                ->required(),

            Textarea::make('remark')
                ->columnSpanFull()



            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('brik_owner.ownership_number')
                ->label('Owner ID')
                ->sortable()
                ->searchable(),

                TextColumn::make('brik_owner.owner.print_name')
                ->label('Owner Name')
                ->sortable()
                ->searchable(),

                TextColumn::make('brik_owner.owner.email')
                ->label('Owner Email')
                ->sortable()
                ->searchable(),


                TextColumn::make('brik_owner.referrer.print_name')
                ->label('Referrer Name')
                ->sortable()
                ->searchable(),

                TextColumn::make('brik_owner.referrer.email')
                ->label('Referrer Email')
                ->sortable()
                ->searchable(),

                TextColumn::make('amount')
                ->sortable()
                ->searchable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function fillReferrer(&$set, &$state)
    {

        $brik_owner = BrikOwner::with(['referrer'])->find($state);
        if($brik_owner){
            if($brik_owner->owner){

                $set('referrer_id', $brik_owner->referrer_id);

                if($brik_owner->referrer){
                    $set('referrer_name', $brik_owner->referrer->full_name);
                }

            }
        }
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }



    public static function getPages(): array
    {
        return [
            'index' => Pages\ListReferralInsentives::route('/'),
            'create' => Pages\CreateReferralInsentive::route('/create'),
            'edit' => Pages\EditReferralInsentive::route('/{record}/edit'),
        ];
    }
}
