<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\RentHeaderSetting;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use Filament\Tables\Columns\BooleanColumn;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\RentHeaderSettingResource\Pages;
use App\Filament\Admin\Resources\RentHeaderSettingResource\RelationManagers;

class RentHeaderSettingResource extends Resource
{
    protected static ?string $model = RentHeaderSetting::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'STAY PORTAL SETTING';

    protected static ?string $modelLabel = 'Heading';
    
    protected static ?string $pluralModelLabel = 'Headings';

    protected static ?string $navigationLabel = 'Heading';

    protected static ?int $navigationSort = 15;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([

                TextInput::make('name')->required(),

                TextInput::make('title')->maxLength(36)->helperText('Maximum 36 characters are allowed. (including spaces)'),

                Select::make('type')
                ->options([
                    "image" => "Image",
                    "carousel_images" => "Carousel Images",
                    "video" => "Video",
                ])
                ->required()
                ->live(),

                

                FileUpload::make('image')
                    ->image()
                    ->required()
                    ->hidden(fn($get) => $get('type') !== 'image')
                    ->directory('images/rent_portal/heading'),

                FileUpload::make('carousel_images')
                    ->image()
                    ->multiple()
                    ->required()
                    ->hidden(fn($get) => $get('type') !== 'carousel_images')
                    ->directory('images/rent_portal/heading'),

                FileUpload::make('video')
                    ->acceptedFileTypes(['video/mp4', 'video/mpeg', 'video/avi', 'video/quicktime']) // Restrict to video files
                    ->maxSize(1024) // Maximum size in KB (100MB here)
                    ->required()
                    ->hidden(fn($get) => $get('type') !== 'video')
                    ->directory('images/rent_portal/heading'),
                    
                Toggle::make('active')->hidden(fn($get) => $get('type') == null),

                
            ])
        ])
        ->columns(1);
       
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                TextColumn::make('name')
                ->sortable()
                ->searchable(),

                TextColumn::make('title')
                ->sortable()
                ->searchable(),

                TextColumn::make('type')
                ->sortable()
                ->searchable(),

                IconColumn::make('active')->boolean(),
            ])
            ->filters([
                //
            ])
            ->actions([


                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ])

                
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRentHeaderSettings::route('/'),
            'create' => Pages\CreateRentHeaderSetting::route('/create'),
            'edit' => Pages\EditRentHeaderSetting::route('/{record}/edit'),
        ];
    }

    
}
