<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use App\Models\RentMoods;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\ImageColumn;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\CheckboxList;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\RentMoodsResource\Pages;
use App\Filament\Admin\Resources\RentMoodsResource\RelationManagers;

class RentMoodsResource extends Resource
{
    protected static ?string $model = RentMoods::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'STAY PORTAL SETTING';

    protected static ?string $modelLabel = 'Mood';
    
    protected static ?string $pluralModelLabel = 'Moods';

    protected static ?string $navigationLabel = 'Mood';

    protected static ?int $navigationSort = 18;

    public static function form(Form $form): Form
    {
        
        return $form
        ->schema([
            Section::make()->schema([

                TextInput::make('name')->maxLength('30')->helperText('Maximum 30 characters are allowed. (including spaces)')->required(),
                
                
                FileUpload::make('image')
                    ->image()
                    ->required()
                    ->directory('images/rent_portal/moods'),

                Select::make('brikUnits')
                    ->relationship('brikUnits', 'unit_name')
                    ->multiple(),

                Toggle::make('active'),
                    
            ])
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                TextColumn::make('name')
                ->sortable()
                ->searchable(),

                ImageColumn::make('image'),

                IconColumn::make('active')->boolean(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRentMoods::route('/'),
            'create' => Pages\CreateRentMoods::route('/create'),
            'edit' => Pages\EditRentMoods::route('/{record}/edit'),
        ];
    }
}
