<?php

namespace App\Filament\Admin\Resources\ReportResource\Pages;

use App\Models\Spv;
use Filament\Forms\Get;
use App\Models\BrikProject;
use Filament\Resources\Pages\Page;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DatePicker;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Actions\Utility\SelectDymanicNames;
use Filament\Forms\Concerns\InteractsWithForms;
use App\Filament\Admin\Resources\ReportResource;
use Symfony\Component\HttpFoundation\StreamedResponse;

class Report extends Page implements HasForms
{
    use InteractsWithForms;

    protected static string $resource = ReportResource::class;

    protected static string $view = 'filament.admin.resources.report-resource.pages.report';

    public $report;
    public $date;
    public $project;
    public $unit;
    public $spv;
    public $email;

    public function mount(): void
    {
        $this->form->fill();
    }

    protected function getFormSchema(): array
    {
        return [

            Section::make('Report Generation of')
                ->description('Pick Report you want to generate.')
                ->schema([

                    Select::make('report')
                        ->label('Report')
                        ->live()
                        ->options([
                            "0" => "BRIK OWNER WISE PAYMENT SHEET",
                            "1" => "UNIT WISE PAYMENT SHEET",
                            "2" => "BRIK OWNER LEDGER",
                            "3" => "BRIK OWNER DETAIL SHEET",
                            "4" => "INSTALLMENT TRACKER SHEET",
                        ])
                         ->afterStateUpdated(function(Get $get, $state){
                              //dd($get("report"));
                            })
                        ->required(),


                ])
                ->columns(2), // Optional: 2-column layout

            Section::make('Filters')
                ->schema([

                    DatePicker::make('date')
                        ->visible(function(Get $get){
                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 0 || $get('report') == 1){
                                return true;
                            }else{
                                return false;
                            }
                        })
                        ->required(function(Get $get){
                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 0 || $get('report') == 1){
                                return true;
                            }else{
                                return false;
                            }
                         }),

                    Select::make('project')
                        ->options(BrikProject::query()->pluck('project_name', 'id'))
                        ->visible(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 0){
                                return true;
                            }else{
                                return false;
                            }
                        })
                        ->required(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 0){
                                return true;
                            }else{
                                return false;
                            }
                         }),

                    Select::make('unit')
                        ->options(SelectDymanicNames::brikUnit())
                        ->visible(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 1){
                                return true;
                            }else{
                                return false;
                            }
                        })
                        ->required(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 1){
                                return true;
                            }else{
                                return false;
                            }
                         }),

                    Select::make('spv')
                        ->options(Spv::query()->pluck('spv_name', 'id'))
                        ->visible(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 1){
                                return true;
                            }else{
                                return false;
                            }
                        })
                        ->required(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 1){
                                return true;
                            }else{
                                return false;
                            }
                         }),

                    TextInput::make('email')
                        ->visible(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 0 || $get('report') == 2 || $get('report') == 3 || $get('report') == 4){
                                return true;
                            }else{
                                return false;
                            }
                        })
                        ->required(function(Get $get){

                            if(is_null($get('report'))){
                                return false;
                            }

                            if($get('report') == 0 || $get('report') == 2 || $get('report') == 3 || $get('report') == 4){
                                return true;
                            }else{
                                return false;
                            }
                         }),



                ])
                ->columns(3), // Optional: 2-column layout
        ];
    }


    public function submit(): StreamedResponse
    {
        $html = '';
        $filename = '';

        $data = $this->form->getState();
        if($data['report'] == 0){
            $report = $this->brikOwnerWisePaymentSheet($data);
        }elseif($data['report'] == 1){
            $report = $this->unitWisePaymentSheet($data);
        }elseif($data['report'] == 2){
            $report = $this->brikOwnerLedger($data);
        }elseif($data['report'] == 3){
            $report = $this->brikOwnerDetailSheet($data);
        }elseif($data['report'] == 4){
            $report = $this->installmentTrackerSheet($data);
        }

        if(isset($report)){
            $html = $report["html"];
            $filename = $report["filename"];
        }


            // Create new Spreadsheet object
            $spreadsheet = new Spreadsheet();

            // Create Html reader
            $reader = \PhpOffice\PhpSpreadsheet\Reader\Html::class;
            $reader = new $reader();

            // Load HTML into Spreadsheet
            $spreadsheet = $reader->loadFromString($html);

            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);



            return response()->streamDownload(function () use ($writer) {
                $writer->save('php://output');
            }, $filename, [
                'Content-Type' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            ]);



    }



    //  "BRIK OWNER WISE PAYMENT SHEET"
    public function brikOwnerWisePaymentSheet($data)
    {
        $html = view('excel.report.brik_ownerwise_payment_sheet')->render();
        $filename = 'BRIK_OWNER_WISE_PAYMENT_SHEET_'.date("d-m-Y_H-i-s");

        return ["html" => $html,"filename" => $filename];
    }

    //  "UNIT WISE PAYMENT SHEET"
    public function unitWisePaymentSheet()
    {
        $html = view('excel.report.unitwise_payment_sheet')->render();
        $filename = 'UNIT_WISE_PAYMENT_SHEET_'.date("d-m-Y_H-i-s");

        return ["html" => $html,"filename" => $filename];
    }

    //  "BRIK OWNER LEDGER"
    public function brikOwnerLedger()
    {
        $html = view('excel.report.brik_owner_ledger')->render();
        $filename = 'BRIK_OWNER_LEDGER_'.date("d-m-Y_H-i-s");

        return ["html" => $html,"filename" => $filename];
    }

    //  "BRIK OWNER DETAIL SHEET"
    public function brikOwnerDetailSheet()
    {
        $html = view('excel.report.brik_owner_detail_sheet')->render();
        $filename = 'BRIK_OWNER_DETAIL_SHEET_'.date("d-m-Y_H-i-s");

        return ["html" => $html,"filename" => $filename];
    }

    //  "INSTALLMENT TRACKER SHEET"
    public function installmentTrackerSheet()
    {
        $html = view('excel.report.installment_tracker_sheet')->render();
        $filename = 'INSTALLMENT_TRACKER_SHEET_'.date("d-m-Y_H-i-s");

        return ["html" => $html,"filename" => $filename];
    }
}
