<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\RuPropertyPrice;
use Filament\Resources\Resource;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\RuPropertyPriceResource\Pages;
use App\Filament\Admin\Resources\RuPropertyPriceResource\RelationManagers;

class RuPropertyPriceResource extends Resource
{
    protected static ?string $model = RuPropertyPrice::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'STAY PORTAL SETTING';

    protected static ?string $modelLabel = 'RU Price';
    
    protected static ?string $pluralModelLabel = 'RU Prices';

    protected static ?string $navigationLabel = 'RU Price';

    protected static ?int $navigationSort = 19;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                TextColumn::make('brik_unit.unit_name')
                ->sortable()
                ->searchable(),

                TextColumn::make('ru_property_id')
                ->sortable()
                ->searchable(),

                TextColumn::make('from_date')
                ->date()
                ->sortable()
                ->searchable(),

                TextColumn::make('to_date')
                ->date()
                ->sortable()
                ->searchable(),

                TextColumn::make('price')
                ->sortable()
                ->searchable(),

            ])
            ->filters([
                //
            ]);
            // ->actions([
            //     Tables\Actions\EditAction::make(),
            // ])
            // ->bulkActions([
            //     Tables\Actions\BulkActionGroup::make([
            //         Tables\Actions\DeleteBulkAction::make(),
            //     ]),
            // ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRuPropertyPrices::route('/'),
            //'create' => Pages\CreateRuPropertyPrice::route('/create'),
            //'edit' => Pages\EditRuPropertyPrice::route('/{record}/edit'),
        ];
    }
}
