<?php

namespace App\Filament\Admin\Resources;

use App\Models\Spv;
use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Get;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use App\Filament\Admin\Resources\SpvResource\Pages;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\SpvResource\RelationManagers;

class SpvResource extends Resource
{
    protected static ?string $model = Spv::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BRIK';

    protected static ?string $modelLabel = 'SPV';
    
    protected static ?string $pluralModelLabel = 'SPVs';

    protected static ?string $navigationLabel = 'SPV';

    protected static ?int $navigationSort = 28;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([

                TextInput::make('spv_name')->required()->unique(ignoreRecord: true),
                DatePicker::make('spv_formation_date'),
              
            ])->columns(2),
            Section::make()->schema([

                
                TextInput::make('bank_name')->required(),
                TextInput::make('bank_account_holder_name')->required(),
                TextInput::make('bank_account_number')->required(),
                TextInput::make('ifsc_code')->required(),

                TextInput::make('pan_card')->label('PAN No.')->required(),
                TextInput::make('coi_number')->label('COI No.'),

                FileUpload::make('pan_card_file')
                    ->label('Pan Copy Upload')
                    ->rules(['mimes:pdf', 'max:10000'])
                    ->directory('documents/spv/pan'),
					
				FileUpload::make('tan_card_file')
                    ->label('Tan Copy Upload')
                    ->rules(['mimes:pdf', 'max:10000'])
                    ->directory('documents/spv/tan'),

                FileUpload::make('coi_file')
                    ->label('COI Copy Upload')
                    ->rules(['mimes:pdf', 'max:20000'])
                    ->directory('documents/spv/coi'),
                
                // FileUpload::make('balance_sheet')
                    // ->rules(['mimes:pdf', 'max:10000'])
                    // ->directory('documents/spv/balancesheet'),

                // FileUpload::make('profit_loss')
                    // ->rules(['mimes:pdf', 'max:20000'])
                    // ->directory('documents/spv/profitloss'),
                    
                
            ])->columns(2),

            Section::make()->schema([

                Toggle::make('online_payment')
                ->live()
                ->columnSpanFull(),

                TextInput::make('cashfree_app_id')
                ->required(function(Get $get){
                    if($get('online_payment')){
                        return true;
                    }else{
                        return false;
                    }
                 })
                ->readOnly(function(Get $get){
                    if($get('online_payment')){
                        return false;
                    }else{
                        return true;
                    }
                 }),

                TextInput::make('cashfree_app_secret')
                ->required(function(Get $get){
                    if($get('online_payment')){
                        return true;
                    }else{
                        return false;
                    }
                 })
                ->readOnly(function(Get $get){
                    if($get('online_payment')){
                        return false;
                    }else{
                        return true;
                    }
                 }),

                
            ])->columns(2)
            
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
        ->query(self::getModel()::query()->orderByDesc('updated_at'))
        ->columns([
            
            

            TextColumn::make('spv_name')
            ->sortable()
            ->searchable(),

            TextColumn::make('spv_formation_date')
            ->sortable()
            ->searchable(),

            TextColumn::make('coi_number')
            ->sortable()
            ->searchable(),

           
        ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                     Tables\Actions\ViewAction::make(),
                     Tables\Actions\EditAction::make(),
                     Tables\Actions\DeleteAction::make()
                     ->action(function ($record) {
                         
                         if ($record->childRecordCounts() > 0 ) {
                             Notification::make()
                                 ->danger()
                                 ->title('SPV is in use')
                                 ->body('Cannot delete this record because related records exist.')
                                 ->send();
 
                                 return;
                         }
 
                         Notification::make()
                                 ->danger()
                                 ->title('Deleted')
                                 ->body('Deleted SPV record.')
                                 ->send();
 
                         $record->delete();
                     }),
                 ])
             ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSpvs::route('/'),
            'create' => Pages\CreateSpv::route('/create'),
            'edit' => Pages\EditSpv::route('/{record}/edit'),
        ];
    }
}
