<?php

namespace App\Http\Controllers\Api\Auth;

use App\Models\Client;
use App\Actions\Sms\SMS;
use App\Actions\Sms\Whatsapp as SmsWhatsapp;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\TempOtp;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Crypt;

class AuthController extends Controller
{
    public function sendotp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile_no' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $client = Client::where('mobile', $request->mobile_no)->first();
        $otp = random_int(100000, 999999);
        if($client){

            $updclient = Client::find($client->id);
            $updclient->otp = $otp;
            $updclient->save();

        }else{

            $instempotp = new TempOtp;
            $instempotp->mobile = $request->mobile_no;
            $instempotp->otp = $otp;
            $instempotp->save();
        }

        // Start Send OTP function here

			//SmsWhatsapp::sendOTP($request->mobile_no, $otp);
			SMS::sendOTP($request->mobile_no, $otp);

        // End Send OTP function here

        return response()->json($this->throwSuccessResponse(["data" => null]));
    }

    public function verifyotp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile_no' => 'required',
            'otp' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        try {
            $matched = false;
            $client = $this->isClientOrNot($request->mobile_no);
            if($client){
                if($client->otp == $request->otp){
                    $matched = true;
                    $access_token = $client->createToken('MyApp')->accessToken; 
                }
            }else{
                $tempotp = TempOtp::where('mobile', $request->mobile_no)->where('otp', $request->otp)->count();
                if($tempotp > 0){
                    
                    $matched = true;
                    $client = new Client;
                    $client->mobile = $request->mobile_no;
                    $client->save();
                    $access_token = $client->createToken('MyApp')->accessToken; 
                }
            }


            if($matched){
				
				$profile_completed = 0;
				if(!is_null($client->first_name) && !is_null($client->last_name)){
					$profile_completed = 1;
				}
				

                $record = [];
                $record['name'] = $client->full_name;
                $record['first_name'] = $client->first_name;
                $record['last_name'] = $client->last_name;
                $record['mobile'] = $client->mobile;
				$record['email'] = $client->email;
                $record['gender'] = $client->gender;
                $record['dob'] = $client->dob;
                $record['address'] = $client->address;
                $record['state'] = $client->state;
                $record['city'] = $client->city;
                $record['pin'] = $client->pin;
                $record['coins'] = $client->coins;
				$record['wallet_amount'] = $client->wallet_amount;
                $record['image'] = $client->image;
                $record['profile_completed'] = $profile_completed;
				$record['is_owner'] = $client->is_owner;
                $record['access_token'] = $access_token;

                return response()->json($this->throwSuccessResponse(["data" => $record]));

            }else{
                return $this->throwFailedResponse('OTP not matched.');
            }
        } catch(\Exception $e){
            return $this->throwFailedResponse($e->getMessage());
        }

    }

    public function verify(Request $request)
    {
        $client = $request->user();
		
		$profile_completed = 0;
		if(!is_null($client->first_name) && !is_null($client->last_name)){
			$profile_completed = 1;
		}

        $record['name'] = $client->full_name;
        $record['first_name'] = $client->first_name;
        $record['last_name'] = $client->last_name;
        $record['mobile'] = $client->mobile;
		$record['email'] = $client->email;
        $record['gender'] = $client->gender;
        $record['dob'] = $client->dob;
        $record['address'] = $client->address;
        $record['state'] = $client->state;
        $record['city'] = $client->city;
        $record['pin'] = $client->pin;
        $record['coins'] = $client->coins;
		$record['wallet_amount'] = $client->wallet_amount;
        $record['image'] = $client->image;
		$record['profile_completed'] = $profile_completed;
		$record['is_owner'] = $client->is_owner;

        return response()->json($this->throwSuccessResponse(["data" => $record]));
    }
	
	public function socialmedialogin(Request $request)
    {
        $image = $this->downloadGoogleImage($request->photo);

        $client = new Client;

        $client->first_name = $request->first_name;

        if(!is_null($request->last_name)){
            $client->last_name = $request->last_name;
        }

        if(!is_null($request->email)){
            $client->email = $request->email;
        }

        if(!is_null($request->phone)){
            $client->mobile = $request->phone;
        }

        if(!is_null($image)){
            $client->image = $image;
        }

        $client->save();
        $access_token = $client->createToken('MyApp')->accessToken;

        $profile_completed = 0;
		if(!is_null($client->first_name) && !is_null($client->last_name)){
			$profile_completed = 1;
		}

        $record = [];
        $record['name'] = $client->full_name;
        $record['first_name'] = $client->first_name;
        $record['last_name'] = $client->last_name;
        $record['mobile'] = $client->mobile;
        $record['email'] = $client->email;
        $record['gender'] = $client->gender;
        $record['dob'] = $client->dob;
        $record['address'] = $client->address;
        $record['state'] = $client->state;
        $record['city'] = $client->city;
        $record['pin'] = $client->pin;
        $record['coins'] = $client->coins;
        $record['wallet_amount'] = $client->wallet_amount;
        $record['image'] = $client->image;
        $record['profile_completed'] = $profile_completed;
        $record['is_owner'] = $client->is_owner;
        $record['access_token'] = $access_token;

        return response()->json($this->throwSuccessResponse(["data" => $record]));
    }

    public function directlogin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'to' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        try{
            $client_id = Crypt::decryptString($request->to);
            $client = Client::find($client_id);
            $access_token = $client->createToken('MyApp')->accessToken;

            $profile_completed = 0;
            if(!is_null($client->first_name) && !is_null($client->last_name)){
                $profile_completed = 1;
            }

            $record['name'] = $client->full_name;
            $record['first_name'] = $client->first_name;
            $record['last_name'] = $client->last_name;
            $record['mobile'] = $client->mobile;
            $record['email'] = $client->email;
            $record['gender'] = $client->gender;
            $record['dob'] = $client->dob;
            $record['address'] = $client->address;
            $record['state'] = $client->state;
            $record['city'] = $client->city;
            $record['pin'] = $client->pin;
            $record['coins'] = $client->coins;
            $record['wallet_amount'] = $client->wallet_amount;
            $record['image'] = $client->image;
            $record['profile_completed'] = $profile_completed;
            $record['is_owner'] = $client->is_owner;
            $record['access_token'] = $access_token;

            return response()->json($this->throwSuccessResponse(["data" => $record]));

        }catch(\Exception $e){
            return response()->json($this->throwFailedResponse($e->getMessage()));
        }




    }
    public function updateprofile(Request $request)
    {
        $client = Client::find($request->user()->id); 

        $client->first_name = $request->first_name;
        $client->last_name = $request->last_name;
		$client->email = $request->email;
		$client->address = $request->address;
		
		if($request->mobile){
           $client->mobile = $request->mobile;
		}
		
		if($request->gender){
			$client->gender = $request->gender;
		}
		
		if($request->dob){
			$client->dob = $request->dob;
		}
        
		if($request->state){
			$client->state = $request->state;
		}
		
		if($request->city){
			$client->city = $request->city;
		}
		
		if($request->pin){
			$client->pin = $request->pin;
		}
        
        $client->save();
		
		$profile_completed = 0;
		if(!is_null($client->first_name) && !is_null($client->last_name)){
			$profile_completed = 1;
		}
		
		$record['name'] = $client->full_name;
        $record['first_name'] = $client->first_name;
        $record['last_name'] = $client->last_name;
        $record['mobile'] = $client->mobile;
		$record['email'] = $client->email;
        $record['gender'] = $client->gender;
        $record['dob'] = $client->dob;
        $record['address'] = $client->address;
        $record['state'] = $client->state;
        $record['city'] = $client->city;
        $record['pin'] = $client->pin;
        $record['coins'] = $client->coins;
        $record['wallet_amount'] = $client->wallet_amount;
        $record['image'] = $client->image;
		$record['profile_completed'] = $profile_completed;
		$record['is_owner'] = $client->is_owner;

        return response()->json($this->throwSuccessResponse(["data" => $record]));
    }

    public function updateprofilepic(Request $request)
    {
        
		$validator = Validator::make($request->all(), [
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }
          
        $client = Client::find($request->user()->id);

        $imageName = time().'.'.$request->image->extension(); 

        $path = $request->image->store('images/clients/profile', 'public');
		

        $client->image = $path;

        $client->save();

        return response()->json($this->throwSuccessResponse(["data" => ["path" => $path]]));
    }

    public function removeprofilepic(Request $request)
    {
        $client = Client::find($request->user()->id);

        if($client){
            $client->image = null;
        }


        $client->save();

        return response()->json($this->throwSuccessResponse(["data" => null]));
    }

    protected function isClientOrNot($mobile){
        return Client::where('mobile', $mobile)->first();
    }

    public function protected(Request $request)
    {
        return response()->json([
            "status" => "ok",
            "token" => $request->user(),
        ]);
    }
	
	public function testingToken(){
		$client = Client::find(1);
		$access_token = $client->createToken('MyApp')->accessToken; 
		
		return response()->json([
            "status" => "ok",
            "token" => $access_token,
        ]);
	}
	
	protected function downloadGoogleImage($imageUrl)
    {
        $imagename = 'images/clients/profile/'.time().'.jpg';
        $savePath = storage_path('app/public/').$imagename;
        // Initialize cURL
        $ch = curl_init($imageUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0'); // Pretend to be a browser

        $imageData = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch)) {
           // echo "cURL error: " . curl_error($ch);
            curl_close($ch);
            return null;
        }

        curl_close($ch);

        if ($httpCode == 200 && $imageData) {
            // Save the image to the desired path
            file_put_contents($savePath, $imageData);
            //echo "Image saved to: $savePath";
            return $imagename;
        } else {
            //echo "Failed to download image. HTTP Code: $httpCode";
            return null;
        }
    }
}
