<?php

namespace App\Http\Controllers\Api\Booking;

use App\Models\Client;
use Illuminate\Http\Request;
use App\Models\BookingBooking;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Models\BookingBookingRequest;
use App\Mail\RentalBookingSuccessToAdmin;
use App\Mail\RentalBookingCancelToClient;
use App\Mail\RentalBookingCancelToAdmin;
use Illuminate\Support\Facades\Validator;
use App\Mail\RentalBookingSuccessToClient;


class BookingEmailController extends Controller
{
    public function sendEmail(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'booking_request_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $error = '';

        try{
            $this->successBookingAdminEmail($request->booking_request_id);
        }catch(\Exception $e){
            $error .= 'Admin send mail failed.';
        }

        try{
            $this->successBookingClientEmail($request->booking_request_id);
        }catch(\Exception $e){
            $error .= ', Client send mail failed. ';
        }


        return response()->json($this->throwSuccessResponse(["data" => null]));
    }
	
	public function sendCancelEmail(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'booking_request_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $error = '';

        try{
            $this->cancelBookingAdminEmail($request->booking_request_id);
        }catch(\Exception $e){
            $error .= 'Admin send mail failed.';
        }

        try{
            $this->cancelBookingClientEmail($request->booking_request_id);
        }catch(\Exception $e){
            $error .= ', Client send mail failed. ';
        }


        return response()->json($this->throwSuccessResponse(["data" => null]));
    }

    public function successBookingAdminEmail($booking_request_id)
    {
		// $admin_emails = [
            // 'reservations@brikitt.com',
            // 'accounts@brikitt.com',
			// 'swati@brikitt.com'
        // ];
		
        $admin_emails = [
            'er.gauravmukherjee@gmail.com',
            'dev.gauravmukherjee@gmail.com'
        ];
		
		
		$bookingRequest = BookingBookingRequest::with(['bookings'])->find($booking_request_id);
        $booking_guest = BookingBooking::where('booking_request_id', $booking_request_id)->first();
        $guest = new Client;
        if($booking_guest){
            $guest = Client::find($booking_guest->client_id);
        }

        Mail::to($admin_emails)->send(new RentalBookingSuccessToAdmin($bookingRequest, $guest));

        return;
    }

    public function successBookingClientEmail($booking_request_id)
    {
        $bookingRequest = BookingBookingRequest::with(['bookings'])->find($booking_request_id);
        $booking_guest = BookingBooking::where('booking_request_id', $booking_request_id)->first();

        if($bookingRequest->booking_status == 'Active')
        {
            if($booking_guest){
                $guest = Client::find($booking_guest->client_id);
                Mail::to($guest->email)->send(new RentalBookingSuccessToClient($bookingRequest, $guest));
            }
        }

        return;
    }
	
	public function cancelBookingAdminEmail($booking_request_id)
    {
		// $admin_emails = [
            // 'reservations@brikitt.com',
            // 'accounts@brikitt.com',
			// 'swati@brikitt.com'
        // ];
		
        $admin_emails = [
            'er.gauravmukherjee@gmail.com',
            'dev.gauravmukherjee@gmail.com'
        ];
		
		
		$bookingRequest = BookingBookingRequest::with(['bookings'])->find($booking_request_id);
        $booking_guest = BookingBooking::where('booking_request_id', $booking_request_id)->first();
        $guest = new Client;
        if($booking_guest){
            $guest = Client::find($booking_guest->client_id);
        }

        Mail::to($admin_emails)->send(new RentalBookingCancelToAdmin($bookingRequest, $guest));

        return;
    }

    public function cancelBookingClientEmail($booking_request_id)
    {
        $bookingRequest = BookingBookingRequest::with(['bookings'])->find($booking_request_id);
        $booking_guest = BookingBooking::where('booking_request_id', $booking_request_id)->first();

        if($booking_guest){
            $guest = Client::find($booking_guest->client_id);
            Mail::to($guest->email)->send(new RentalBookingCancelToClient($bookingRequest, $guest));
        }

        return;
    }



}
