<?php

namespace App\Http\Controllers\Api\Booking;

use App\Models\BrikSpv;
use App\Models\BrikBrik;
use App\Models\BrikUnit;
use App\Models\BrikProject;
use Illuminate\Http\Request;
use App\Models\BookingBooking;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\DetailPageResource;
use App\Http\Resources\LandingPageCollection;
use App\Http\Resources\LandingPageResource;

class BrikController extends Controller
{
    public function list(Request $request)
    {
        if($request->has('city')){
            if(!is_null($request->city)){

                $project_ids = BrikProject::where('city_id', $request->city)->pluck('id')->toArray();

                $units = BrikUnit::whereIn('project_id', $project_ids)->with(['brik','project.city'])
				->where(function($query){
                    $query->where('invest_active', 1)->where('rent_active', 1);
                })
                 ->orWhere(function($query){
                    $query->where('managed_property', 1);
                 })
				->paginate(12);

                return response()->json(new LandingPageCollection($units));
                //return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
            }
        }

        //$units = BrikUnit::with(['brik','project.city'])->paginate(12);
		$units = BrikUnit::with(['brik','project.city'])
                 ->where(function($query){
                    $query->where('invest_active', 1)->where('rent_active', 1);
                })
                 ->orWhere(function($query){
                    $query->where('managed_property', 1);
                 })
                ->paginate(12); 
        return response()->json(new LandingPageCollection($units));
       // return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }

    
    public function listnew()
    {
        //$units = BrikUnit::with(['brik','project.city'])->where('newly_launched', 1)->paginate(10);
		$units = BrikUnit::with(['brik','project.city'])->where('newly_launched', 1)
                 ->where(function($query){
                    $query->where('invest_active', 1)->where('rent_active', 1);
                })
                 ->orWhere(function($query){
                    $query->where('managed_property', 1);
                 })
				->paginate(10); 
        return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }

    public function listnewall()
    {
        //$units = BrikUnit::with(['brik','project.city'])->where('newly_launched', 1)->paginate(12);
		$units = BrikUnit::with(['brik','project.city'])->where('newly_launched', 1)
                 ->where(function($query){
                    $query->where('invest_active', 1)->where('rent_active', 1);
                })
                 ->orWhere(function($query){
                    $query->where('managed_property', 1);
                 })
				->paginate(12); 
        return response()->json(new LandingPageCollection($units));
        //return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }

    public function highlyrated()
    {
        //$units = BrikUnit::with(['brik','project.city'])->where('rating','>=', 4)->orderBy('rating', 'DESC')->paginate(10);
		$units = BrikUnit::with(['brik','project.city'])->where('rating','>=', 4)
                 ->where(function($query){
                    $query->where('invest_active', 1)->where('rent_active', 1);
                })
                 ->orWhere(function($query){
                    $query->where('managed_property', 1);
                 })
				->orderBy('rating', 'DESC')
				->paginate(10); 
        return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }

    public function highlyratedall()
    {
        $units = BrikUnit::with(['brik','project.city'])->where('rating','>=', 4)->orderBy('rating', 'DESC')->get();
        return response()->json(new LandingPageCollection($units));
    }

    public function brikdetail($id)
    {
        $unit = BrikUnit::with(['project','brik','unitRatings','unitRatings.client','project.city','project.state', 'brik.amenities','brik.addOnServices','brik.propertyType', 'project.houseRule','project.cancellationPolicy', 'project.safetyAndProperty','project.petsFriendly','project.nearbyPlaces'])->findOrFail($id);

        //return response()->json($this->throwSuccessResponse(["data" => $unit]));
        return response()->json($this->throwSuccessResponse(["data" => new DetailPageResource($unit)]));
    }

    public function filter(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'city_id' => 'required',
            'adults' => 'required',
            //'date_check_in' => 'sometimes|date',
            //'date_check_out' => 'sometimes|date|after:date_check_in',
            
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $validated = $validator->validated();

       // $project_ids = BrikProject::where('city_id', $validated["city_id"])->pluck('id')->toArray();

       // $briks = BrikBrik::whereIn('brik_project_id', $project_ids)->where('adults_capacity','>=', $validated["adults"]);

       $units = BrikUnit::where('city_id', $validated["city_id"])
                        ->where('adults_capacity','>=', $validated["adults"]);

        if($request->children){
            $units = $units->where('children_capacity','>=', $request->children);
        }

        if($request->infents){
            $units = $units->where('infent_capacity','>=', $request->infents);
        }

        if($request->pets){
            $units = $units->where('pet_capacity','>=', $request->pets);
        }

        $valid_unit_ids = $units->pluck('id')->toArray();

        $blocked_unit_ids = [];

        if($request->date_check_in && $request->date_check_out)
        {
            $blocked_unit_ids  = BookingBooking::select('brik_unit_id')->where('booking_status', 'Active')
                            ->where(function ($query) use ($request) {
                                $query->whereBetween('date_check_in', [$request->date_check_in, $request->date_check_out])
                                    ->orWhereBetween('date_check_out', [$request->date_check_in, $request->date_check_out])
                                    ->orWhere(function ($q) use ($request) {
                                        $q->where('date_check_in', '<=', $request->date_check_in)
                                        ->where('date_check_out', '>=', $request->date_check_out);
                                    });
                            })->pluck('brik_unit_id')->toArray();
        }

        $avl_unit_ids = array_values(array_diff($valid_unit_ids, $blocked_unit_ids));

        $units = BrikUnit::with(['brik','project.city'])->whereIn('id', $avl_unit_ids)->where('rent_active', 1)
                 ->orderBy('adults_capacity', 'DESC')
                ->paginate(12);
      
        return response()->json(new LandingPageCollection($units));
        //return response()->json($this->throwSuccessResponse(new LandingPageCollection($units)));
        
    }
}
