<?php

namespace App\Http\Controllers\Api\Booking;

use App\Models\BrikSpv;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\DetailPageResource;
use App\Http\Resources\LandingPageResource;
use App\Models\BrikBrik;
use App\Models\BrikProject;
use App\Models\BrikUnit;

class BrikController extends Controller
{
    public function list(Request $request)
    {
        if($request->has('city')){
            if(!is_null($request->city)){
                $project_ids = BrikProject::where('city_id', $request->city)->pluck('id')->toArray();

                $units = BrikUnit::whereIn('project_id', $project_ids)->with(['brik','project.city'])->where('rent_active', 1)->get();
                return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
            }
        }
        $units = BrikUnit::with(['brik','project.city'])->where('rent_active', 1)->get();
        return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }

    
    public function listnew()
    {
        $units = BrikUnit::with(['brik','project.city'])->where('newly_launched', 1)->where('rent_active', 1)->get();
        return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }

    public function highlyrated()
    {
        $units = BrikUnit::with(['brik','project.city'])->where('rating','>=', 4)->where('rent_active', 1)->orderBy('rating', 'DESC')->get();
        return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }

    public function brikdetail($id)
    {
        $unit = BrikUnit::with(['project','brik','unitRatings','unitRatings.client','project.city','project.state', 'brik.amenities','brik.addOnServices','brik.propertyType', 'project.houseRule','project.cancellationPolicy', 'project.safetyAndProperty','project.petsFriendly','project.nearbyPlaces'])->findOrFail($id);

        //return response()->json($this->throwSuccessResponse(["data" => $unit]));
        return response()->json($this->throwSuccessResponse(["data" => new DetailPageResource($unit)]));
    }
}
