<?php

namespace App\Http\Controllers\Api\Booking;

use App\Actions\RU\RU;
use App\Models\Client;
use App\Models\BrikSpv;
use App\Models\BrikBrik;
use App\Models\BrikUnit;
use App\Models\RuRlnmLog;
use Illuminate\Http\Request;
use App\Actions\RU\XmlToJson;
use App\Models\BookingBooking;
use App\Models\ClientWishlist;
use App\Models\ClientWishlistItem;
use App\Http\Controllers\Controller;
use App\Models\BookingBookingDetail;
use App\Models\BookingBookingRequest;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\LandingPageResource;
use App\Http\Resources\WishlistItemResource;
use App\Models\BookingCancellationPolicyMaster;

class RURLNMController extends Controller
{

    public function register(Request $request)
    {

		$ru = new RU;
        $res = $ru->setRLNM();
        dd($res);
    }

    public function handle(Request $request)
    {
        // 1. Detect RLNM method
        $method = $request->header('ru-rlnm-method');

        // 2. Raw XML body
        $xml = $request->getContent();
		
		//dd($xml);
		$rlmnlog = new RuRlnmLog;
		$rlmnlog->xml_body = $xml;
		$rlmnlog->ru_rlnm_method = $method;
		$rlmnlog->save();
		//RuRlnmLog::create(["xml_body" => $xml]);

		// try(){
			// RuRlnmLog::create(["xml_body" => $xml]);
		// }catch(\Exception $e){

		// }

        // Convert XML to array
        $xml = simplexml_load_string($xml);

        $data = XmlToJson::toArray($xml);

        // 3. Switch based on method name
        switch ($method) {
            case 'LNM_PutConfirmedReservation_RRQ':
            case 'LNM_PutConfirmedReservation_RQ':
                return $this->handleConfirmedReservation($data);

            case 'LNM_CancelReservation_RQ':
                return $this->handleCancelReservation($data);

            case 'LNM_PutLeadReservation_RQ':
                return $this->handleLeadReservation($data);

            case 'LNM_PutUnconfirmedReservation_RQ':
                return $this->handleUnconfirmedReservation($data);

            default:
                //\Log::warning("Unknown RLNM Method: ".$method);
        }

        // 4. Return 200 OK always
        return response()->json(['status' => 'ok'], 200);
    }

    private function handleConfirmedReservation($result)
    {
        if(array_key_exists("Reservation", $result)){

            try{

                if(array_key_exists(0, $result["Reservation"]))
                {

                    $res = $result["Reservation"];

                }else{

                    $res[0] = $result["Reservation"];
                }

            }catch(\Exception $e){
                $res = [];
            }

        }

        foreach($res as $reservation)
        {
            //dd($reservations, $reservation);
            $booking = BookingBooking::where('ru_reservation_id', $reservation['ReservationID'])->first();
            if($booking)
            {

                // Nothing to do as booking already present.
				// if($reservation['StatusID'] == 2)
                // {

                //     if($booking->booking_status != 'Cancel')
                //     {
                //         $daycounts = $this->countDays(date('Y-m-d', strtotime($reservation['LastMod'])), $booking->date_check_in);

                //         $percent_deduction = 0;

                //         $ref = BookingCancellationPolicyMaster::where('days_from', '>=', $daycounts)->where('days_to','<=',$daycounts)->first();

                //         if($ref){
                //             $percent_deduction = $ref->percent_deduction;
                //         }

                //         $bookingupd = BookingBooking::find($booking->id);

                //         $bookingupd->booking_status = 'Cancel';

                //         if($booking->pay_by == 'Coin'){

                //             $coin_deducted = ($booking->booking_cost_in_coin * ($percent_deduction / 100));
                //             $coin_refunded = ($booking->booking_cost_in_coin - $coin_deducted);

                //             $bookingupd->deducted_coins = $coin_deducted;
                //             $bookingupd->refunded_coins = $coin_refunded;

                //         }else if($booking->pay_by == 'Amount'){

                //             $amount_deducted = ($booking->net_payable_amount * ($percent_deduction / 100));
                //             $amount_refunded = ($booking->net_payable_amount - $amount_deducted);

                //             $bookingupd->deducted_amount = $amount_deducted;
                //             $bookingupd->refunded_amount = $amount_refunded;
                //         }

                //         $bookingupd->save();

                //         $bookingRequest = BookingBookingRequest::find($bookingupd->booking_request_id);
                //         $bookingRequest->booking_status = 'Cancel';
                //         $bookingRequest->save();

                //     }
                // }
			}
			else
			{

               $brik_unit = BrikUnit::where('ru_property_id', $reservation['StayInfos']['StayInfo']['PropertyID'])->first();

               if($brik_unit){

                    $isBookingExist = $this->isBookingExist(
                                        $brik_unit->id,
                                        $reservation['StayInfos']['StayInfo']['DateFrom'],
                                        $reservation['StayInfos']['StayInfo']['DateTo'],
                                      );

                    if($isBookingExist)
                    {

                      // Nothing to do as booking already present.

                    }
                    else
                    {
                        // Here Booking needs to create

                        $brik_unit_id = $brik_unit->id;

                        $this->booking(
                            $brik_unit_id,
                            $reservation['StayInfos']['StayInfo']['DateFrom'],
                            $reservation['StayInfos']['StayInfo']['DateTo'],
                            $reservation['StayInfos']['StayInfo']['Costs'],
                            $reservation['StayInfos']['StayInfo']['NumberOfGuests'],
                            $reservation['CustomerInfo'],
                            $reservation['ReservationID']
                        );

                    }

               }

            }
       }
       return response()->json(['received' => true], 200);
    }

    private function handleCancelReservation($result)
    {
        if(array_key_exists("Reservation", $result)){

            try{

                if(array_key_exists(0, $result["Reservation"]))
                {

                    $res = $result["Reservation"];

                }else{

                    $res[0] = $result["Reservation"];
                }

            }catch(\Exception $e){
                $res = [];
            }

        }

        foreach($res as $reservation)
        {

            $booking = BookingBooking::where('ru_reservation_id', $reservation['ReservationID'])->first();
            if($booking)
            {
                if($booking->booking_status != 'Cancel')
                {
                    $daycounts = $this->countDays(date('Y-m-d', strtotime($reservation['LastMod'])), $booking->date_check_in);

                    $percent_deduction = 0;

                    $ref = BookingCancellationPolicyMaster::where('days_from', '>=', $daycounts)->where('days_to','<=',$daycounts)->first();

                    if($ref){
                        $percent_deduction = $ref->percent_deduction;
                    }

                    $bookingupd = BookingBooking::find($booking->id);

                    $bookingupd->booking_status = 'Cancel';

                    if($booking->pay_by == 'Coin'){

                        $coin_deducted = ($booking->booking_cost_in_coin * ($percent_deduction / 100));
                        $coin_refunded = ($booking->booking_cost_in_coin - $coin_deducted);

                        $bookingupd->deducted_coins = $coin_deducted;
                        $bookingupd->refunded_coins = $coin_refunded;

                    }else if($booking->pay_by == 'Amount'){

                        $amount_deducted = ($booking->net_payable_amount * ($percent_deduction / 100));
                        $amount_refunded = ($booking->net_payable_amount - $amount_deducted);

                        $bookingupd->deducted_amount = $amount_deducted;
                        $bookingupd->refunded_amount = $amount_refunded;
                    }

                    $bookingupd->save();

                    $bookingRequest = BookingBookingRequest::find($bookingupd->booking_request_id);
                    $bookingRequest->booking_status = 'Cancel';
                    $bookingRequest->save();

                }
			}

       }

        return response()->json(['received' => true], 200);
    }

    private function handleLeadReservation($data)
    {
       // \Log::info("Lead Reservation", $data);

        // TODO: Create lead/quote etc.

        return response()->json(['received' => true], 200);
    }

    private function handleUnconfirmedReservation($data)
    {
        //\Log::info("Unconfirmed Reservation", $data);

        // TODO: Soft-block dates until confirmed.

        return response()->json(['received' => true], 200);
    }

        public function isBookingExist($brik_unit_id, $date_blocked_from, $date_blocked_to)
    {
        return BookingBookingRequest::where('brik_unit_id', $brik_unit_id)->where('booking_status', 'Active')
                    ->where(function ($query) use ($date_blocked_from, $date_blocked_to) {
                        $query->whereBetween('date_blocked_from', [$date_blocked_from, $date_blocked_to])
                            ->orWhereBetween('date_blocked_to', [$date_blocked_from, $date_blocked_to])
                            ->orWhere(function ($q) use ($date_blocked_from, $date_blocked_to) {
                                $q->where('date_blocked_from', '<=', $date_blocked_from)
                                  ->where('date_blocked_to', '>=', $date_blocked_to);
                            });
                    })->exists();

    }

    public function addClient($customerInfo)
    {

        $first_name = is_array($customerInfo["Name"]) ? null : $customerInfo["Name"];
        $last_name = is_array($customerInfo["SurName"]) ? null : $customerInfo["SurName"];
        $email = is_array($customerInfo["Email"]) ? null : $customerInfo["Email"];
        $phone = is_array($customerInfo["Phone"]) ? ( is_array($customerInfo["MobilePhone"]) ? null : $customerInfo["MobilePhone"] )  : $customerInfo["Phone"];
        $address = is_array($customerInfo["Address"]) ? null : $customerInfo["Address"];
        $pin = is_array($customerInfo["ZipCode"]) ? null : $customerInfo["ZipCode"];

        $client = Client::where('mobile', $phone)->first();
        if($client){

            return $client->id;

        }else{

            $cins = new Client;
            $cins->mobile = $phone;
            $cins->first_name = $first_name;
            $cins->last_name = $last_name;
            $cins->email = $email;
            $cins->address = $address;
            $cins->pin = $pin;
            $cins->save();

            return $cins->id;
        }

        //$this->info('Client added executed.');
    }

    public function bookingRequest($brik_unit_id, $date_check_in, $date_check_out)
    {
        $date_blocked_from = $date_check_in;
        $date_blocked_to = date("Y-m-d",strtotime("-1 day ".$date_check_out));

        $booking_request = new BookingBookingRequest;
        $booking_request->brik_unit_id = $brik_unit_id;
        $booking_request->booking_from_date = $date_check_in;
        $booking_request->booking_to_date = $date_check_out;
        $booking_request->date_blocked_from = $date_blocked_from;
        $booking_request->date_blocked_to = $date_blocked_to;
        $booking_request->booking_status = 'Active';
        $booking_request->ru_sync_required = 0;
        $booking_request->save();

         //$this->info('Booking request executed.');
        return $booking_request;
    }

    public function booking($brik_unit_id, $date_check_in, $date_check_out, $costs, $guest, $customerInfo, $ru_id)
    {
        //dump('in booking');
        $booking_request = $this->bookingRequest($brik_unit_id, $date_check_in, $date_check_out);
        $client_id = $this->addClient($customerInfo);
        $nights = $this->countDays($date_check_in, $date_check_out);
        $pricing = $this->ru_pricing($nights, $costs);

        //$this->info('Booking execution started.');
        $payBooking = new BookingBooking;
        $payBooking->booking_request_id = $booking_request->id;
        $payBooking->date_check_in = $date_check_in;
        $payBooking->date_check_out = $date_check_out;
        //$payBooking->price_per_night = $request->payment_booking["price_per_night"];
        $payBooking->booking_night_counts = $nights;
        $payBooking->booking_cost_in_rupee = $pricing["payable_amount"];
        $payBooking->brik_coupon_id = null;
        $payBooking->coupon_amount = null;
        $payBooking->payable_amount = $pricing["payable_amount"];
        $payBooking->gst_amount = $pricing["gst"];
        $payBooking->net_payable_amount = $pricing["net_payable_amount"];
        $payBooking->paid_amount = $pricing["net_payable_amount"];
        $payBooking->balance_amount = 0;
        $payBooking->pay_by = 'Amount';
        $payBooking->adult = $guest;
        $payBooking->children = 0;
        $payBooking->infants = 0;
        $payBooking->pets = 0;
        $payBooking->booking_status = 'Active';
        $payBooking->pay_order_id = null;
        $payBooking->brik_unit_id = $brik_unit_id;
        $payBooking->client_id = $client_id;
        $payBooking->ru_reservation_id = $ru_id;
        $payBooking->booking_from = 'RU';
        $payBooking->save();
       // $this->info('Booking execution ended.');

        //$this->info('Booking Detail execution started.');
        $payBookingDetail = new BookingBookingDetail;
        $payBookingDetail->booking_id = $payBooking->id;
        $payBookingDetail->from_date = $date_check_in;
        $payBookingDetail->to_date = $date_check_out;
        $payBookingDetail->price = $pricing["price_per_night"];
        $payBookingDetail->nights = $nights;
        $payBookingDetail->booking_price = $pricing["payable_amount"];
        $payBookingDetail->save();
        //$this->info('Booking Detail execution ended.');

    }

    protected function countDays($fromdate,$todate)
    {
        $from = strtotime($fromdate);
        $to = strtotime($todate);
        $diff = round(($to - $from) / (60 * 60 * 24));

        if($from === $to){
            return 1;
        }else{
            return (int)$diff;
        }
    }

    protected function ru_pricing($nights, $costs)
    {
       $net_payable_amount = $costs["RUPrice"];
       $gst = $costs["RUPrice"] * (18 / 100);
       $payable_amount = $net_payable_amount - $gst;
       $price_per_night = $payable_amount / $nights;

       return [
            "price_per_night" => $price_per_night,
            "payable_amount" => $payable_amount,
            "gst" => $gst,
            "net_payable_amount" => $net_payable_amount,
       ];

    }

}
