<?php

namespace App\Http\Controllers\Api\Booking;


use App\Models\BrikUnit;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\LandingPageResource;
use App\Models\RentHeaderSetting;
use App\Models\RentMoods;
use App\Models\RentPromotionSetting;
use App\Models\RentTrustedVilla;

class SettingController extends Controller
{

    public function heading(Request $request)
    {
		$heading = RentHeaderSetting::where('active', 1)->first();
       
        return response()->json($this->throwSuccessResponse(["data" => $heading]));
    }

    public function promotion(Request $request)
    {
		$promotion = RentPromotionSetting::where('active', 1)->first();
       
        return response()->json($this->throwSuccessResponse(["data" => $promotion]));
    }

    public function trustedVillas(Request $request)
    {
		$villas = RentTrustedVilla::where('active', 1)->get();
       
        return response()->json($this->throwSuccessResponse(["data" => $villas]));
    }

    public function moods(Request $request)
    {
		$moods = RentMoods::where('active', 1)->get();
       
        return response()->json($this->throwSuccessResponse(["data" => $moods]));
    }

    public function moodunits($mood_id)
    {
		$mood = RentMoods::with(['brikUnits'])->find($mood_id);

        $moodunits = $mood ? $mood->brikUnits->pluck('id')->toArray() : [];

        $units = BrikUnit::with(['brik','project.city'])->whereIn('id', $moodunits)->get();

        return response()->json($this->throwSuccessResponse(["data" => LandingPageResource::collection($units)]));
    }
    
}
