<?php

namespace App\Http\Controllers\Api\Invest;

use Illuminate\Http\Request;
use App\Mail\InvestContactForm;
use App\Http\Controllers\Controller;
use App\Mail\InvestBecomeChannelPartnerForm;
use App\Mail\InvestJobApplyForm;
use Illuminate\Support\Facades\Mail;

class InvestEmailsController extends Controller
{
    public $email = 'info@brikitt.com';

    public function contact_us(Request $request)
    {
        //name
        //email
        //phone
        //message
        //city
        //about
        //hear_about_brikitt
        Mail::to($this->email)->send(new InvestContactForm($request));
        return response()->json($this->throwSuccessResponse(
            [
                "data" => null
            ]
        ));
    }

    public function become_channel_partner(Request $request)
    {
        $profile = '';
        if($request->hasFile('profile')){
            $profilepath = $request->profile->store('email', 'public');
            $profile = env("APP_URL").'storage/'.$profilepath;
        }

        $pan = '';
        if($request->hasFile('pan')){
            $panpath = $request->pan->store('email', 'public');
            $pan = env("APP_URL").'storage/'.$panpath;
        }

        $aadhaar = '';
        if($request->hasFile('pan')){
            $aadhaarpath = $request->pan->store('email', 'public');
            $aadhaar = env("APP_URL").'storage/'.$aadhaarpath;
        }

        $data = [
            "name" => $request->name,
            "email" => $request->email,
            "phone" => $request->phone,
            "state" => $request->state,
            "city" => $request->city,
            "zip" => $request->zip,
            "about" => $request->about,
            "profile" => $profile,
            "pan" => $pan,
            "aadhaar" => $aadhaar
        ];

        Mail::to($this->email)->send(new InvestBecomeChannelPartnerForm($data));
        return response()->json($this->throwSuccessResponse(
            [
                "data" => null
            ]
        ));
    }

    public function job_apply(Request $request)
    {
        //name
        //email
        //phone
        //city
        //position
        //linkedin
        Mail::to($this->email)->send(new InvestJobApplyForm($request));
        return response()->json($this->throwSuccessResponse(
            [
                "data" => null
            ]
        ));
    }


}
