<?php

namespace App\Http\Controllers\Api\Invest;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\InvestPropertyBooking;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\Actions\Payment\InvestBookingPayment;
use App\Models\InvestEnquiry;

class PropertyBookingController extends Controller
{
    public function book(Request $request)
    {

        $validator = Validator::make($request->all(), [
		
		    'invest_property_detail_id' => 'required',
            'name' => 'required|max:255',
            'email' => 'required|max:100',
            'country_code' => 'required|max:100',
            'amount' => 'required',
            'zip_code' => 'required',
            'phone' => 'required|max:100',
            'state' => 'required|max:255',
            'city' => 'required|max:255',
            'photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'pan_file' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'aadhaar_front' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'aadhaar_back' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $photo_path = $request->photo->store('images/invest/booking', 'public');
        $pan_file_path = $request->pan_file->store('images/invest/booking', 'public');
        $aadhaar_front_path = $request->aadhaar_front->store('images/invest/booking', 'public');
        $aadhaar_back_path = $request->aadhaar_back->store('images/invest/booking', 'public');

        $qry = new InvestPropertyBooking;
		$qry->invest_property_detail_id = $request->invest_property_detail_id;
        $qry->name = $request->name;
        $qry->email = $request->email;
        $qry->country_code = $request->country_code;
        $qry->phone = $request->phone;
        $qry->state = $request->state;
        $qry->city = $request->city;
        $qry->amount = $request->amount;
        $qry->zip_code = $request->zip_code;
        $qry->photo = $photo_path;
        $qry->pan_file = $pan_file_path;
        $qry->aadhaar_front = $aadhaar_front_path;
        $qry->aadhaar_back = $aadhaar_back_path;
        $qry->order_no = 'BRIK-INVEST-'.rand(10000000, 100000000);
        $qry->save();



        return response()->json($this->throwSuccessResponse(
            [
                "data" => [
                    'url' => route('invest.payment', $qry->order_no)
                ]
            ]
        ));


        //return response()->json($this->throwSuccessResponse(["data" => InvestLandingPageResource::collection($projects)]));
    }

    public function payment($order_no){

        $invest_property_booking = InvestPropertyBooking::where('order_no', $order_no)->first();
        if($invest_property_booking){
            $payment = new InvestBookingPayment;
            $url = $payment->generateLink($invest_property_booking);
			
			return redirect()->away($url);
            //return view('invest-payment', compact('url'));
        }else{
            abort(404);
        }

    }

	public function paymentreturn(Request $request){

        $payment = new InvestBookingPayment;
		$invest_booking_id = $payment->paymentReturn($request);

        $redirecturl = env("FRONTEND_APP_URL").'invest-property-booking-status?request='.$invest_booking_id;

        return Redirect::to($redirecturl);

	}

    public function paymentcancel(Request $request){

        $payment = new InvestBookingPayment;
		$invest_booking_id = $payment->paymentCancel($request);

        $redirecturl = env("FRONTEND_APP_URL").'invest/invest-property-booking-status?request='.$invest_booking_id;

        return Redirect::to($redirecturl);
    }

    public function paymentDetails(Request $request){

        $validator = Validator::make($request->all(), [
            'invest_booking_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $record = InvestPropertyBooking::find($request->invest_booking_id);
        return response()->json($this->throwSuccessResponse(["data" => $record]));
    }

    public function enquiry(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'brik_project_id' => 'required',
            'name' => 'required|max:255',
            'email' => 'required|max:255',
            'phone' => 'required|max:100',
            'city' => 'required|max:100',
            'select_type' => 'required|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        try{
            $qry = new InvestEnquiry;
            $qry->brik_project_id = $request->brik_project_id;
            $qry->name = $request->name;
            $qry->email = $request->email;
            $qry->city = $request->city;
            $qry->phone = $request->phone;
            $qry->select_type = $request->select_type;
            $qry->save();

        }catch(\Exception $e){

            return $this->throwFailedResponse($e->getMessage());

        }

        return response()->json($this->throwSuccessResponse(["data" => $qry]));

   }

}
