<?php

namespace App\Http\Controllers\Api\Owner;


use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\OwnerDetailPageResource;
use App\Http\Resources\OwnerLandingPageResource;

class OwnerBrikController extends Controller
{
    public function list(Request $request)
    {
       // $filtered_units = BrikOwner::where('owner_id', $request->user()->id)->groupBy('brik_unit_id')->pluck('id')->toArray();
		//dd($filtered_units);
		//$filtered_unit_ids = array_unique($filtered_units); 
		
		
		
        $units = BrikOwner::with(['brik_unit','brik_unit.brik','brik_unit.project','brik_unit.project.state','brik_unit.project.city','brik_unit.spv'])->where('owner_id', $request->user()->id)
        //->where('disabled', 0)
		->groupBy('brik_unit_id')
        ->get();
		//->groupBy('brik_unit_id');
		
		//dd($units);
		
        //dd($units);
         return response()->json($this->throwSuccessResponse(["data" => OwnerLandingPageResource::collection($units)]));
        //return response()->json($this->throwSuccessResponse(["data" => $units]));

        $units = BrikOwner::with(['brik_unit','brik_unit.brik','brik_unit.brik.type','brik_unit.project','brik_unit.project.state','brik_unit.project.city','brik_unit.spv'])->where('owner_id', $request->user()->id)->where('disabled', 0)->get();


    }

    
    public function brikdetail(Request $request, $id)
    {
        $unit = BrikOwner::with(['brik_unit','brik_unit.project','brik_unit.brik','brik_unit.unitRatings','brik_unit.unitRatings.client','brik_unit.project.city','brik_unit.project.state', 'brik_unit.brik.amenities','brik_unit.brik.propertyType','brik_unit.spv','brik_unit.project.projectManager','referrer'])->findOrFail($id);

       
        return response()->json($this->throwSuccessResponse(["data" => new OwnerDetailPageResource($unit)]));
    }

}
