<?php

namespace App\Http\Controllers\Api\Owner;


use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\OwnerDetailPageResource;
use App\Http\Resources\OwnerLandingPageResource;
use App\Http\Resources\OwnerPaymentPlanResource;
use App\Models\BrikAnnualMaintenance;
use App\Models\BrikConstuctionImage;
use App\Models\BrikInstallment;
use App\Models\BrikPaymentmyplan;
use App\Models\BrikUnit;
use App\Models\Spv;

class OwnerDocumentsController extends Controller
{
    public function show($unit_id, Request $request)
    {
        $brik_unit_id = $unit_id;
        $owner_id = $request->user()->id;

        $paidinstaments = [];
        $paidmaintenances = [];
        $pan_file = null;
        $coi_file = null;
		$tan_file = null;
		$allotment_letter = null;
		$registroy_copy = null;
        $constructionImages = [];

        $br = BrikOwner::where('owner_id', $owner_id)
                ->where('brik_unit_id', $brik_unit_id)
                ->with(['payment_plan'])->first();

        if($br){

            if($br->payment_plan){

				$installments = BrikInstallment::where('payment_plan_id', $br->payment_plan->id)
							->where('installment_paid', 1)->get();

				foreach($installments as $installment){
					$paidinstaments[] = [
						"data" => $installment,
						"url" => route('installment.receipt', $installment->id),
					];
				}

				$amcs = BrikAnnualMaintenance::where('brik_owner_id', $br->id)->where('maintenance_paid', 1)->get();

				foreach($amcs as $amc){
					$paidmaintenances[] = [
						"data" => $amc,
						"url" => route('amc.receipt', $amc->id),
					];
				}
			}

        }

        $bu = BrikUnit::find($brik_unit_id);

        if($bu){
            $spv = Spv::find($bu->spv_id);
            if($spv){
                $pan_file = $spv->pan_card_file;
                $tan_file = $spv->tan_card_file;
				$coi_file = $spv->coi_file;
            }
			
			$allotment_letter = $bu->allotment_letter_file;
			$registroy_copy = $bu->registry_file;
        }

        $constructionImages = BrikConstuctionImage::where('brik_unit_id', $brik_unit_id)->get();
        
        $response_body = [
            "payment_receipt" => [
                "installments" => $paidinstaments,
                "maintenace" => $paidmaintenances,
            ],
            "pan_certificate" => $pan_file,
			"tan_certificate" => $tan_file,
            "certificate_of_incorporation" => $coi_file,
			"allotment_letter" => $allotment_letter,
			"registry_copy" => $registroy_copy,
            "constuction_uploads" => $constructionImages, 
        ]; 

        
        
        return response()->json($this->throwSuccessResponse(
            [
                "data" => $response_body
            ]
        ));
    }

    public function showReminder($unit_id,Request $request)
    {
        $brik_owner = BrikOwner::where('brik_unit_id', $unit_id)->where('owner_id', $request->user()->id)->first();

        if($brik_owner){

             
                $maintanances = BrikAnnualMaintenance::with('BrikOwner')
                ->where('brik_owner_id', $brik_owner->id)
                ->where('maintenance_paid',0)
                ->get();

                return response()->json($this->throwSuccessResponse(
                    ["data" => $maintanances
                ]));
            
            
        }
        
        return response()->json($this->throwSuccessResponse(
            ["data" => null
        ]));
        
    }


}
