<?php

namespace App\Http\Controllers\Api\Owner;

use Illuminate\Http\Request;
use App\Models\BookingBooking;
use App\Http\Controllers\Controller;
use App\Actions\Utility\FinancialYear;

class OwnerGrowthController extends Controller
{
    public function growth($unit_id, Request $request){

        $dates = FinancialYear::getFinancialDaterange(date("Y-m-d"));

        $total_nights = 30;
		
		$used_nights = BookingBooking::where('date_check_in','>=', $dates["from"])->where('date_check_out','<=', $dates["to"])
                    ->where('client_id', $request->user()->id)
                    ->where('brik_unit_id', $unit_id)
                    ->where('pay_by', 'Coin')
                    ->where('booking_status', 'Active')
                    ->sum('booking_night_counts');

        $remaining_nights = $total_nights - (int)$used_nights;

        $record = [
            ["name" => 'Total Used Days', "value" => $used_nights],
            ["name" => 'Remaining Days', "value" => $remaining_nights]
        ];

        return response()->json($this->throwSuccessResponse(
                    ["data" => $record
                ]));
    }

    public function revenue($unit_id, Request $request)
    {
        $years = [
                    date("Y", strtotime('-2 year')),
                    date("Y", strtotime('-1 year')),
                    date("Y")
        ];

        $records = [];

        foreach($years as $year){

            $data = [];
            foreach($this->months() as $month){

                $date = $year.'-'.$month["month_number"].'-%';
                $sum = BookingBooking::where('brik_unit_id', $unit_id)
                        ->where('booking_status', 'Active')
                        ->where('date_check_in','LIKE', $date)
                        ->orWhere('date_check_out','LIKE', $date)
                        ->sum('paid_amount');

                $data[] = ["month" => $month["month_name"], "revenue" => $sum];
            }

            $records[] = [
                "year" => $year,
                "data" => $data,
            ];

        }

        return response()->json($this->throwSuccessResponse(
                    ["data" => $records
                ]));
    }

    public function months()
    {

        return [
                [
                    "month_name" => "JAN",
                    "month_number" => "01"
                ],
                [
                    "month_name" => "FEB",
                    "month_number" => "02"
                ],
                [
                    "month_name" => "MAR",
                    "month_number" => "03"
                ],
                [
                    "month_name" => "APR",
                    "month_number" => "04"
                ],
                [
                    "month_name" => "MAY",
                    "month_number" => "05"
                ],
                [
                    "month_name" => "JUN",
                    "month_number" => "06"
                ],
                [
                    "month_name" => "JUL",
                    "month_number" => "07"
                ],
                [
                    "month_name" => "AUG",
                    "month_number" => "08"
                ],
                [
                    "month_name" => "SEP",
                    "month_number" => "09"
                ],
                [
                    "month_name" => "OCT",
                    "month_number" => "10"
                ],
                [
                    "month_name" => "NOV",
                    "month_number" => "11"
                ],
                [
                    "month_name" => "DEC",
                    "month_number" => "12"
                ]

            ];

    }





}
