<?php

namespace App\Http\Controllers\Api\Owner;


use App\Models\Spv;
use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Models\BrikInstallment;
use App\Models\BrikInstallmentPayment;
use App\Models\BrikPaymentmyplan;
use App\Actions\Payment\SpvPayment;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\OwnerDetailPageResource;
use App\Http\Resources\OwnerLandingPageResource;
use App\Http\Resources\OwnerPaymentPlanResource;

class OwnerInstallmentPaymentController extends Controller
{
    public function show($ownership_id, Request $request)
    {
        $brik_owner = BrikOwner::find($ownership_id);
        if($brik_owner){

            if($brik_owner->paymentmyplan_id)
            {
                
                $paidinstallments = BrikInstallment::with('payments','paymentPlan','paymentPlan.brik_owner')
                ->where('active', 1)
				->where('installment_paid', 1)
                ->where('payment_plan_id', $brik_owner->paymentmyplan_id);
				
				//->orderBy('due_date', 'ASC')
                //->get();
				
				$unpaidinstallments = BrikInstallment::with('payments','paymentPlan','paymentPlan.brik_owner')
                ->where('active', 1)
				->where('installment_paid', 0)
                ->where('payment_plan_id', $brik_owner->paymentmyplan_id);
				//->limit(1);
				
				$installments = $paidinstallments->union($unpaidinstallments)->orderBy('due_date', 'ASC')->get();
				

                return response()->json($this->throwSuccessResponse(
                    ["data" => $installments
                ]));
            }
            
        }
        
        return response()->json($this->throwSuccessResponse(
            ["data" => null
        ]));
    }

    public function showReminder($ownership_id,Request $request)
    {
        $brik_owner = BrikOwner::find($ownership_id);
        if($brik_owner){

            if($brik_owner->paymentmyplan_id)
            {
                
                $installments = BrikInstallment::with('paymentPlan','paymentPlan.brik_owner')
                ->where('active', 1)
                ->where('installment_paid', 0)
                ->where('payment_plan_id', $brik_owner->paymentmyplan_id)
				->limit(1)
				->orderBy('due_date', 'ASC')
                ->get();

                return response()->json($this->throwSuccessResponse(
                    ["data" => $installments
                ]));
            }
            
        }
        
        return response()->json($this->throwSuccessResponse(
            ["data" => null
        ]));
        
    }

    public function payment(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'installment_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $pay_order = 'BRIK-INST-'.rand(10000000, 100000000);
        $inst = BrikInstallment::find($request->installment_id);
        $inst->pay_order_id = $pay_order;
        $inst->save();

        $spv_id = null;
        $payment_plan = BrikPaymentmyplan::with(['brik_owner','brik_owner.brik_unit'])->find($inst->payment_plan_id);
        if($payment_plan->brik_owner){
            if($payment_plan->brik_owner->brik_unit){
                $spv_id = $payment_plan->brik_owner->brik_unit->spv_id;
            }else{
                return response()->json($this->throwFailedResponse('Brik Unit Record not found!'));
            }
        }else{
            return response()->json($this->throwFailedResponse('Brik Owner Record not found!'));
        }

        $spv = null;
        if($spv_id){
            $spv = Spv::find($spv_id);
        }else{
            return response()->json($this->throwFailedResponse('Spv id not found!'));
        }

        if(is_null($spv)){
            return response()->json($this->throwFailedResponse('Spv Record not found!'));
        }

        $cashfree_app_id = null;
        $cashfree_app_secret = null;
        if($spv->online_payment == 1){
            if(!is_null($spv->cashfree_app_id) && !is_null($spv->cashfree_app_secret)){
                $cashfree_app_id = $spv->cashfree_app_id;
                $cashfree_app_secret = $spv->cashfree_app_secret;
            }
        }else{
            return response()->json($this->throwFailedResponse('Online payment not enabled in spv.'));
        }

        if(is_null($cashfree_app_id) || is_null($cashfree_app_secret)){
            return response()->json($this->throwFailedResponse('Cashfree app id and/or secret not set.'));
        }

        $returnurl = route('installment.payment.return').'?order='.$pay_order.'&installment_id='.$request->installment_id;

        $inst = BrikInstallment::find($request->installment_id);
        $payment = new SpvPayment($cashfree_app_id, $cashfree_app_secret);
        $payment->addClientInfo(Auth::user());
        $payment->addBookingInfo($inst); // If event is booking
        $payment->addReturnUrl($returnurl);
        $payment_req = $payment->generateSession();

        if($payment_req["cf_order_id"] && $inst->id){

            $upd = BrikInstallment::find($inst->id);
            $upd->cf_order_id = $payment_req["cf_order_id"];
            $upd->save();
        }
                
        return response()->json($this->throwSuccessResponse([
            "mode" => 'payment',
            "data" => $payment_req,
        ]));
    }

    // Payment Gateway Endpoint
    public function paymentreturn(Request $request)
    {
        $order_id = $request->order;
        $installment_id = $request->installment_id;

        $inst = BrikInstallment::find($request->installment_id);
        
        $payment_status = 'ACTIVE';

        $spv_id = null;
        $payment_plan = BrikPaymentmyplan::with(['brik_owner','brik_owner.brik_unit'])->find($inst->payment_plan_id);
        if($payment_plan->brik_owner){
            if($payment_plan->brik_owner->brik_unit){
                $spv_id = $payment_plan->brik_owner->brik_unit->spv_id;
            }else{
                return response()->json($this->throwFailedResponse('Brik Unit Record not found!'));
            }
        }else{
            return response()->json($this->throwFailedResponse('Brik Owner Record not found!'));
        }

        $spv = null;
        if($spv_id){
            $spv = Spv::find($spv_id);
        }else{
            return response()->json($this->throwFailedResponse('Spv id not found!'));
        }

        if(is_null($spv)){
            return response()->json($this->throwFailedResponse('Spv Record not found!'));
        }

        $cashfree_app_id = null;
        $cashfree_app_secret = null;
        if($spv->online_payment == 1){
            if(!is_null($spv->cashfree_app_id) && !is_null($spv->cashfree_app_secret)){
                $cashfree_app_id = $spv->cashfree_app_id;
                $cashfree_app_secret = $spv->cashfree_app_secret;
            }
        }else{
            return response()->json($this->throwFailedResponse('Online payment not enabled in spv.'));
        }

        if(is_null($cashfree_app_id) || is_null($cashfree_app_secret)){
            return response()->json($this->throwFailedResponse('Cashfree app id and/or secret not set.'));
        }
		
        $payment = new SpvPayment($cashfree_app_id, $cashfree_app_secret);

        $payment_res = $payment->getOrderInfo($order_id);
		
		if($payment_res["order_status"]){
			
			
            if($payment_res["order_status"] == 'PAID'){

                $payment_status = 'PAID';
				
				$inspay = new BrikInstallmentPayment;
				$inspay->brik_installment_id = $installment_id;
				$inspay->paid_amount = $inst->balance_amount;
				$inspay->date = date("Y-m-d");
				$inspay->save();
				
				$sum_paid_amt = BrikInstallmentPayment::where('brik_installment_id', $installment_id)->sum('paid_amount');
				$balance_amt = ($inst->payable_amount - $sum_paid_amt);
				
				$installment_paid = 0;
				if($balance_amt == 0){
					$installment_paid = 1; 
				}
				
                BrikInstallment::where('id', $installment_id)->update([
                    "payment_status" => $payment_status,
                    "amount_paid" => $sum_paid_amt,
					"balance_amount" => $balance_amt,
                    "installment_paid" => $installment_paid,
                    "paid_date" => date("Y-m-d"),
                ]);

            }else{

			}

        }

        $redirecturl = env("FRONTEND_APP_URL").'installment-status?installment='.$installment_id;

        return Redirect::to($redirecturl);
    }

    public function installmentPaymentDetails(Request $request){

        $validator = Validator::make($request->all(), [
            'installment' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $inst = BrikInstallment::with(['paymentPlan','paymentPlan.brik_owner','paymentPlan.brik_owner.brik_unit','paymentPlan.brik_owner.brik_unit.project', 'paymentPlan.brik_owner.brik_unit.brik'])->find($request->installment);
		
		
        return response()->json($this->throwSuccessResponse(["data" => $inst]));
    }


}
