<?php

namespace App\Http\Controllers\Api\Utility;

use App\Models\BrikCity;
use App\Models\BrikState;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Resources\CityResource;
use App\Http\Resources\CityCollection;

class CityController extends Controller
{
    public function list()
    {
        $cities = BrikCity::with(['state'])->orderBy('is_enabled', 'DESC')->orderBy('updated_at', 'DESC')->get(); 
        return response()->json($this->throwSuccessResponse(["data" => CityResource::collection($cities)]));
    }

    public function statelist()
    {
        $states = DB::table('cities')->select('city_state')->groupBy('city_state')->orderBy('city_state')->get();
        return response()->json($this->throwSuccessResponse(["data" => $states]));
    }

    public function citylist()
    {
        $cities = DB::table('cities')->select('city_name')->orderBy('city_name')->get();
        return response()->json($this->throwSuccessResponse(["data" => $cities]));
    }

    public function citylistbystate($state_name)
    {
        $cities = DB::table('cities')->where('city_state', $state_name)->select('city_name')->orderBy('city_name')->get();
        return response()->json($this->throwSuccessResponse(["data" => $cities]));
    }
}
