<?php

namespace App\Http\Controllers;

abstract class Controller
{
    public function throwFailedResponse($errormsg){

        return [
            "status" => false,
            "error" => [
                "type" => 'General Error',
                "message" => $errormsg
            ]
            ];
    }

    public function throwValidationFailedResponse($errormsg){

        return [
            "status" => false,
            "error" => [
                "type" => 'Validation Error',
                "message" => $errormsg
            ]
            ];
    }

    public function throwSuccessResponse($data){
        
        return array_merge([
            "status" => true,
        ], $data);
    }

    public function modifyValidationErrors($msgbag){
        
        if(count($msgbag) > 0){
            
           $newbag = [];
           foreach($msgbag as $key => $value){
          
               $newbag[$key] = implode(PHP_EOL, $value);
              
            }
            return $newbag;
        }

        return $msgbag;
    }
}
