<?php

namespace App\Http\Controllers;

use Knp\Snappy\Pdf;
use Illuminate\Http\Request;
use App\Models\BookingBooking;
use App\Models\BrikInstallment;
use Illuminate\Support\Facades\DB;
use App\Models\BookingBookingRequest;
use App\Models\BrikAnnualMaintenance;

class ReceiptController extends Controller
{
    public function installment($installment_id){

		$inst = BrikInstallment::with(['paymentPlan','paymentPlan.brik_owner','paymentPlan.brik_owner.owner','paymentPlan.brik_owner.brik_unit','paymentPlan.brik_owner.brik_unit.project', 'paymentPlan.brik_owner.brik_unit.brik','paymentPlan.brik_owner.brik_unit.spv'])->find($installment_id);

			if(!$inst){
				abort(500);
			}

		//dd($inst);

            $html = view('receipt.installment', compact('inst'))->render();
			$snappy = new Pdf(env('WKHTMLTOPDF_BINARY_ADDR', ''));

			/** For Stream */
			 header('Content-Type: application/pdf');
			 echo $snappy->getOutputFromHtml($html,[
			     'orientation' => 'portrait',
			 ]);
    }

    public function amc($maintenance_id){

        $amc = BrikAnnualMaintenance::with(['BrikOwner','BrikOwner.owner','BrikOwner.brik_unit','BrikOwner.brik_unit.project', 'BrikOwner.brik_unit.brik','BrikOwner.brik_unit.spv'])->find($maintenance_id);

			if(!$amc){
				abort(500);
			}

		//dd($inst);

            $html = view('receipt.maintenance', compact('amc'))->render();
			$snappy = new Pdf(env('WKHTMLTOPDF_BINARY_ADDR', ''));

			/** For Stream */
			 header('Content-Type: application/pdf');
			 echo $snappy->getOutputFromHtml($html,[
			     'orientation' => 'portrait',
			 ]);
     }

	 public function rentbooking($booking_request_id)
	 {
		 $booking_req = BookingBookingRequest::with(['bookings','bookings.details', 'bookings.client','bookings.brik_unit'])->find($booking_request_id);

		 $chkBooking = BookingBooking::where('pay_by', 'Amount')->where('booking_request_id', $booking_request_id)->first();
		 if($chkBooking){
			$booking = $chkBooking;
		 }else{
			$booking = BookingBooking::where('booking_request_id', $booking_request_id)->first();
		 }

		$client = [
			"name" => null,
			"phone" => null,
			"state" => null,
			"state_code" => null,
		];

		if($booking_req){

			if(count($booking_req->bookings) > 0){
				$client = $booking_req->bookings[0]->client;
				//dd($client);
				if($client){
					$state_code = null;
					$city = DB::table('cities')->where('city_state', $client->state)->first();
					if($city){
						//$state_code = $city->state_code.'-';
					}
					$client = [
						"name" => $client->first_name.' '.$client->last_name,
						"phone" => $client->mobile,
						"state" => $client->state,
						"state_code" => $state_code,
					];
				}
			}
		}

		//dd($booking_req);

		// return view('receipt.rentbooking', compact('booking_req', 'client', 'booking'));
		 $html = view('receipt.rentbooking', compact('booking_req', 'client', 'booking'))->render();
		 $snappy = new Pdf(env('WKHTMLTOPDF_BINARY_ADDR', ''));

		/** For Stream */
			header('Content-Type: application/pdf');
			echo $snappy->getOutputFromHtml($html,[
				'orientation' => 'portrait',
			]);
	 }
}
