<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'city' => $this->name,
            'state' => $this->state->name,
			'icon_name' => $this->icon_name,
            'icon' => $this->icon,
			'is_enabled' => $this->is_enabled
        ];
    }
}
