<?php

namespace App\Http\Resources;

use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Models\BrikOwnerContactRequest;
use Illuminate\Http\Resources\Json\JsonResource;

class CoOwnerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $sender_owner_id = $request->user()->id;
        $is_display = null;
		$is_self = $request->user()->id == $this->owner->id ? true : false;
        $boc = BrikOwnerContactRequest::where('receiver_owner_id', $this->owner->id)
                ->where('sender_owner_id', $sender_owner_id)->first();

        $ownership = BrikOwner::with(['owner'])->where('brik_unit_id', $this->brik_unit_id)->where('owner_id', $this->owner->id)->sum('ownership');
        
        if($boc){

            if($boc->request_status == 0){
                $is_display = 'Approval Pending';
            }else if($boc->request_status == 1){
                $is_display = 'Approved';
            }else if($boc->request_status == 2){
                $is_display = 'Approval Declined';
            }
            
        }
                
        return [
            'id' => $this->id,
            'ownership' => $ownership,
            'ownership_outof' => $this->ownership_outof,
            'ownership_sq' =>  $this->ownership_sq,
            'owner' => [
                'id' => $this->owner->id,
                'first_name' => $this->owner->first_name,
                'last_name' => $this->owner->last_name,
                'image'  => $this->owner->image,
                'profession' => $this->owner->profession,
                'mobile' => $this->owner->mobile,
            ],
			'is_self' => $is_self,
            'is_display_information' => $is_display,
            
        ];
    }
}
