<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\ClientWishlist;
use App\Models\RuPropertyPrice;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class DetailPageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        
        $is_liked = false;
        if(Auth::guard('api')->check()){
           
            if(ClientWishlist::where('client_id', Auth::guard('api')->user()->id)->where('brik_unit_id', $this->id)->count() > 0){
                $is_liked = true;
            }
        }

        $price_per_night = null;
       
        $ru_price = RuPropertyPrice::where('brik_unit_id', $this->id)
		->where('from_date','<=', date("Y-m-d"))->where('to_date', '>=', date("Y-m-d"));

		if($ru_price->count() > 0){
			$price_per_night = $ru_price->first()->price;
		}
            
        
        return [

            'brik_unit_id' => $this->id,
            'brik_unit_name' => $this->booking_portal_display_name,
            'description' => $this->project->rent_description, 
            'project_name' => $this->project->name,
            'unit_number' => $this->unit_number,
            'property_view' => $this->property_view,
            'property_type' => $this->brik->propertyType->name,
            'cover_image' => $this->invest_cover_image ? $this->invest_cover_image : $this->brik->brik_invest_cover_image,
			'gallery_images' => $this->invest_gallery_images ? $this->invest_gallery_images : $this->brik->brik_invest_gallery_images,
            'amenities' => $this->brik->amenities,
            'add_on_services' => $this->brik->addOnServices,
            'house_rule' => $this->project->houseRule,
            'cancellation_policy' => $this->project->cancellationPolicy,
            'safety_and_property' => $this->project->safetyAndProperty,
            'pets_friendly' => $this->project->petsFriendly,
            'nearby_places' => $this->project->nearbyPlaces,
			'adults_capacity' => $this->brik->adults_capacity,
			'children_capacity' => $this->brik->children_capacity,
			'bedroom' => $this->brik->bedroom,
            'bathroom' => $this->brik->bathroom,
            'accomadation' => $this->brik->accomadation,
            'property_area' => $this->brik->property_area,
            'price_per_night' => is_null($price_per_night) ? $this->brik->per_night_inr : (float)$price_per_night,
			'coin_per_night' => $this->per_night_coin,
            'address' => $this->project->address,
            'state' => $this->project->state->name,
            'city' => $this->project->city->name,
            'pin' => $this->project->pin,
            'lat' => $this->project->lat,
            'lng' => $this->project->lng,
			'pets_allowed' => $this->project->pets_allowed,
			'avg_rating' => $this->rating,
			'like' => $is_liked,
            
        ];
    }
}
