<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InvestLandingPageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'slug' => $this->slug,
            'project_name' => $this->project->project_name,
			'invest_portal_display_name' => $this->invest_portal_display_name,
            'state' => $this->project ? ($this->project->state ? $this->project->state->name : null) : null,
			'city' => $this->project ? ($this->project->city ? $this->project->city->name : null) : null,
            'cover_image' => $this->cover_image,
			'brik_value' => $this->brik_value ? round($this->brik_value) : null,
            'status' => $this->status,
        ];
    }
}
