<?php

namespace App\Http\Resources;

use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Models\ClientWishlist;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class OwnerLandingPageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $ownership = BrikOwner::where('brik_unit_id', $this->brik_unit->id)->where('owner_id', $request->user()->id)->sum('ownership');
		
		$can_book = false;
		
		if($this->brik_unit->invest_active == 1 && $this->brik_unit->rent_active){
			$can_book = true;
		} 
        
        return [

            'brik_ownership_id' => $this->id,
            'brik_unit_id' => $this->brik_unit->id,
            'brik_unit_name' => $this->brik_unit->unit_name,
			'category' => $this->brik_unit ? $this->brik_unit->brik->type->name : null,
           // 'ownership_string' => $this->ownership_string,
            'ownership_string' => $ownership.'/11',
            'brik_project_name' => $this->brik_unit->project->project_name,
            'cover_image' => $this->brik_unit->invest_cover_image ? $this->brik_unit->invest_cover_image : $this->brik_unit->brik->brik_invest_cover_image,
			'gallery_images' => $this->brik_unit->invest_gallery_images ? $this->brik_unit->invest_gallery_images : $this->brik_unit->brik->brik_invest_gallery_images,
			'adults_capacity' => $this->brik_unit->brik->adults_capacity,
			'children_capacity' => $this->brik_unit->brik->children_capacity,
			'bedroom' => $this->brik_unit->brik->bedroom,
            'address' => $this->brik_unit->project->address,
            'state' => $this->brik_unit->project->state->name,
            'city' => $this->brik_unit->project->city->name,
            'lat' => $this->brik_unit->project->lat,
            'lng' => $this->brik_unit->project->lng,
            'price_per_night' => $this->brik_unit->brik->per_night_inr,
            'spv' => $this->brik_unit->spv,
			'can_book' => $can_book,
           
            
        ];
    }
}
