<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BookingBooking extends Model
{
    protected $fillable = ['booking_request_id','price_per_night','coins_per_night','date_check_in','date_check_out','booking_night_counts','booking_cost_in_rupee','booking_cost_in_coin',	'brik_coupon_id','coupon_amount','payable_amount','gst_amount','net_payable_amount','paid_amount',	'balance_amount','pay_by','adult','children','infants','pets','booking_status','order_id','brik_unit_id', 'client_id', 'user_id'];

    public function details()
    {
        return $this->hasMany(BookingBookingDetail::class, 'booking_id');
    }

    public function guests()
    {
        return $this->hasMany(BookingGuestDetail::class, 'booking_booking_id');
    }

    public function booking_request()
    {
        return $this->belongsTo(BookingBookingRequest::class, 'booking_request_id');
    }

    public function brik_unit()
    {
        return $this->belongsTo(BrikUnit::class, 'brik_unit_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }



    protected static function booted()
    {
        static::created(function ($record) {

                BookingBooking::where('id', $record->id)->update(['order_id' => 'BRKSTAY-'.$record->id]);

        });

    }

}
